/*
 * Decompiled with CFR 0.152.
 */
package cc.catalysts.boot.i18n.config;

import cc.catalysts.boot.i18n.controller.ClientEnumController;
import cc.catalysts.boot.i18n.controller.I18nController;
import cc.catalysts.boot.i18n.service.I18nService;
import cc.catalysts.boot.i18n.service.ListResourceBundleMessageSource;
import cc.catalysts.boot.i18n.service.impl.I18nServiceImpl;
import cc.catalysts.boot.i18n.service.impl.ListResourceBundleMessageSourceImpl;
import java.nio.charset.Charset;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnMissingBean(value={MessageSource.class}, search=SearchStrategy.CURRENT)
@Conditional(value={CatResourceBundleCondition.class})
@AutoConfigureBefore(value={MessageSourceAutoConfiguration.class})
@ConfigurationProperties(prefix="spring.messages")
public class I18nAutoConfiguration
extends MessageSourceAutoConfiguration {
    private String[] getBasenames() {
        String basename = this.getBasename();
        if (StringUtils.hasText((String)basename)) {
            return StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)basename));
        }
        return null;
    }

    @Bean
    public ListResourceBundleMessageSourceImpl messageSource() {
        Charset encoding;
        ListResourceBundleMessageSourceImpl messageSource = new ListResourceBundleMessageSourceImpl();
        String[] basenames = this.getBasenames();
        if (basenames != null) {
            messageSource.setBasenames(basenames);
        }
        if ((encoding = this.getEncoding()) != null) {
            messageSource.setDefaultEncoding(encoding.name());
        }
        messageSource.setFallbackToSystemLocale(this.isFallbackToSystemLocale());
        messageSource.setCacheSeconds(this.getCacheSeconds());
        return messageSource;
    }

    @Bean
    I18nService i18nApi(ListResourceBundleMessageSource messageSource) {
        return new I18nServiceImpl(messageSource);
    }

    @Bean
    I18nController i18nController(I18nService i18NService) {
        return new I18nController(i18NService);
    }

    @Bean
    ClientEnumController clientEnumController(MessageSource messageSource) {
        return new ClientEnumController(messageSource);
    }

    protected static class CatResourceBundleCondition
    extends MessageSourceAutoConfiguration.ResourceBundleCondition {
        protected CatResourceBundleCondition() {
        }
    }
}

