package cc.carlos.application;

import android.app.Application;
import android.support.v4.content.LocalBroadcastManager;

import java.util.HashMap;

import cc.carlos.application.exception.BaseAppException;

/**
 * Created by zhangheilong on 15/5/28.
 */
public class BaseApplication extends Application {
    private HashMap<String, Object> hash;
    public static BaseApplication _instance;
    private LocalBroadcastManager localBroadcastManager;

    @Override
    public void onCreate() {
        super.onCreate();
        _instance = (BaseApplication) getApplicationContext();
    }

    public void saveObject(String key, Object object) {
        if (hash == null) {
            hash = new HashMap<>();
        }
        hash.put(key, object);
    }


    public Object getObject(String key) {
        if (hash == null) {
            hash = new HashMap<>();
            throw new BaseAppException("object doesn't exist");
        }
        if (hash.containsKey(key)) {
            return hash.get(key);
        } else {
            throw new BaseAppException("object doesn't exist");
        }
    }

    public void removeObject(String key) {
        if (hash == null) {
            return;
        }
        if (hash.containsKey(key)) {
            hash.remove(key);
        } else {
            return;
        }
    }

    public LocalBroadcastManager getLocalBroadcastManager() {
        if (localBroadcastManager == null) {
            localBroadcastManager = LocalBroadcastManager.getInstance(_instance);
        }
        return localBroadcastManager;
    }
}
