(ns tern.log
  "Adapted from leiningen.core.main, so it can be used inside
  `eval-in-project` where leiningen isn't available."
  (:require [tern.color :refer [style]])
  (:refer-clojure :exclude [keyword]))

(def ^:dynamic *debug* (System/getenv "DEBUG"))

(defn debug
  "Print if *debug* (from DEBUG environment variable) is truthy."
  [& args]
  (when *debug* (apply println (style "[DEBUG]" :default)  args)))

(def ^:dynamic *info* (not (System/getenv "LEIN_SILENT")))

(defn info
  "Print if *info* (from LEIN_SILENT environment variable) is truthy."
  [& args]
  (when *info* (apply println (style "[INFO]" :green) args)))

(defn warn
  "Print to stderr if *info* is truthy."
  [& args]
  (when *info*
    (binding [*out* *err*]
      (apply println (style "[WARN]" :yellow) args))))

(defn error
  "Always print errors"
  [& args]
  (apply println (style "[ERROR]" :red) args))

(defn highlight
  "Print text in blue."
  [c]
  (style c :blue))

(defn filename
  "Print filenames in magenta"
  [filename]
  (style filename :magenta))

(defn danger
  "Print warning text in red"
  [warning]
  (style warning :red))

(defn keyword
  "Print keywords in blue."
  [kw]
  (style kw :blue))

;; The license of Leiningen, from which this namespace was adapted, follows
;; below. Leiningen can be found at https://github.com/technomancy/leiningen.
;;
;; Source code distributed under the Eclipse Public License - v 1.0:
;;
;; THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF THIS ECLIPSE
;; PUBLIC LICENSE ("AGREEMENT"). ANY USE, REPRODUCTION OR DISTRIBUTION OF
;; THE PROGRAM CONSTITUTES RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
;;
;; 1. DEFINITIONS
;;
;; "Contribution" means:
;;
;; a  in the case of the initial Contributor, the initial code and
;; documentation distributed under this Agreement, and
;;
;; b  in the case of each subsequent Contributor:
;;
;; i  changes to the Program, and
;;
;; ii  additions to the Program;
;;
;; where such changes and/or additions to the Program originate from and
;; are distributed by that particular Contributor. A Contribution
;; 'originates' from a Contributor if it was added to the Program by such
;; Contributor itself or anyone acting on such Contributor's
;; behalf. Contributions do not include additions to the Program which:
;; (i) are separate modules of software distributed in conjunction with
;; the Program under their own license agreement, and (ii) are not
;; derivative works of the Program.
;;
;; "Contributor" means any person or entity that distributes the Program.
;;
;; "Licensed Patents" mean patent claims licensable by a Contributor
;; which are necessarily infringed by the use or sale of its Contribution
;; alone or when combined with the Program.
;;
;; "Program" means the Contributions distributed in accordance with this
;; Agreement.
;;
;; "Recipient" means anyone who receives the Program under this
;; Agreement, including all Contributors.
;;
;; 2. GRANT OF RIGHTS
;;
;; a  Subject to the terms of this Agreement, each Contributor hereby
;; grants Recipient a non-exclusive, worldwide, royalty-free copyright
;; license to reproduce, prepare derivative works of, publicly display,
;; publicly perform, distribute and sublicense the Contribution of such
;; Contributor, if any, and such derivative works, in source code and
;; object code form.
;;
;; b  Subject to the terms of this Agreement, each Contributor hereby
;; grants Recipient a non-exclusive, worldwide, royalty-free patent
;; license under Licensed Patents to make, use, sell, offer to sell,
;; import and otherwise transfer the Contribution of such Contributor, if
;; any, in source code and object code form.  This patent license shall
;; apply to the combination of the Contribution and the Program if, at
;; the time the Contribution is added by the Contributor, such addition
;; of the Contribution causes such combination to be covered by the
;; Licensed Patents. The patent license shall not apply to any other
;; combinations which include the Contribution. No hardware per se is
;; licensed hereunder.
;;
;; c  Recipient understands that although each Contributor grants the
;; licenses to its Contributions set forth herein, no assurances are
;; provided by any Contributor that the Program does not infringe the
;; patent or other intellectual property rights of any other entity. Each
;; Contributor disclaims any liability to Recipient for claims brought by
;; any other entity based on infringement of intellectual property rights
;; or otherwise. As a condition to exercising the rights and licenses
;; granted hereunder, each Recipient hereby assumes sole responsibility
;; to secure any other intellectual property rights needed, if any. For
;; example, if a third party patent license is required to allow
;; Recipient to distribute the Program, it is Recipient's responsibility
;; to acquire that license before distributing the Program.
;;
;; d  Each Contributor represents that to its knowledge it has sufficient
;; copyright rights in its Contribution, if any, to grant the copyright
;; license set forth in this Agreement.
;;
;; 3. REQUIREMENTS
;;
;; A Contributor may choose to distribute the Program in object code form
;; under its own license agreement, provided that:
;;
;; a  it complies with the terms and conditions of this Agreement; and
;;
;; b  its license agreement:
;;
;; i  effectively disclaims on behalf of all Contributors all warranties
;; and conditions, express and implied, including warranties or
;; conditions of title and non-infringement, and implied warranties or
;; conditions of merchantability and fitness for a particular purpose;
;;
;; ii  effectively excludes on behalf of all Contributors all liability
;; for damages, including direct, indirect, special, incidental and
;; consequential damages, such as lost profits;
;;
;; iii  states that any provisions which differ from this Agreement are
;; offered by that Contributor alone and not by any other party; and
;;
;; iv  states that source code for the Program is available from such
;; Contributor, and informs licensees how to obtain it in a reasonable
;; manner on or through a medium customarily used for software exchange.
;;
;; When the Program is made available in source code form:
;;
;; a  it must be made available under this Agreement; and
;;
;; b  a copy of this Agreement must be included with each copy of the Program.
;;
;; Contributors may not remove or alter any copyright notices contained
;; within the Program.
;;
;; Each Contributor must identify itself as the originator of its
;; Contribution, if any, in a manner that reasonably allows subsequent
;; Recipients to identify the originator of the Contribution.
;;
;; 4. COMMERCIAL DISTRIBUTION
;;
;; Commercial distributors of software may accept certain
;; responsibilities with respect to end users, business partners and the
;; like. While this license is intended to facilitate the commercial use
;; of the Program, the Contributor who includes the Program in a
;; commercial product offering should do so in a manner which does not
;; create potential liability for other Contributors. Therefore, if a
;; Contributor includes the Program in a commercial product offering,
;; such Contributor ("Commercial Contributor") hereby agrees to defend
;; and indemnify every other Contributor ("Indemnified Contributor")
;; against any losses, damages and costs (collectively "Losses") arising
;; from claims, lawsuits and other legal actions brought by a third party
;; against the Indemnified Contributor to the extent caused by the acts
;; or omissions of such Commercial Contributor in connection with its
;; distribution of the Program in a commercial product offering.  The
;; obligations in this section do not apply to any claims or Losses
;; relating to any actual or alleged intellectual property
;; infringement. In order to qualify, an Indemnified Contributor must: a
;; promptly notify the Commercial Contributor in writing of such claim,
;; and b  allow the Commercial Contributor tocontrol, and cooperate with
;; the Commercial Contributor in, the defense and any related settlement
;; negotiations. The Indemnified Contributor may participate in any such
;; claim at its own expense.
;;
;; For example, a Contributor might include the Program in a commercial
;; product offering, Product X. That Contributor is then a Commercial
;; Contributor. If that Commercial Contributor then makes performance
;; claims, or offers warranties related to Product X, those performance
;; claims and warranties are such Commercial Contributor's responsibility
;; alone. Under this section, the Commercial Contributor would have to
;; defend claims against the other Contributors related to those
;; performance claims and warranties, and if a court requires any other
;; Contributor to pay any damages as a result, the Commercial Contributor
;; must pay those damages.
;;
;; 5. NO WARRANTY
;;
;; EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE PROGRAM IS
;; PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
;; KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY
;; WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY
;; OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
;; responsible for determining the appropriateness of using and
;; distributing the Program and assumes all risks associated with its
;; exercise of rights under this Agreement , including but not limited to
;; the risks and costs of program errors, compliance with applicable
;; laws, damage to or loss of data, programs or equipment, and
;; unavailability or interruption of operations.
;;
;; 6. DISCLAIMER OF LIABILITY
;;
;; EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT NOR
;; ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT, INDIRECT,
;; INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING
;; WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
;; LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OR
;; DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED
;; HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
;;
;; 7. GENERAL
;;
;; If any provision of this Agreement is invalid or unenforceable under
;; applicable law, it shall not affect the validity or enforceability of
;; the remainder of the terms of this Agreement, and without further
;; action by the parties hereto, such provision shall be reformed to the
;; minimum extent necessary to make such provision valid and enforceable.
;;
;; If Recipient institutes patent litigation against any entity
;; (including a cross-claim or counterclaim in a lawsuit) alleging that
;; the Program itself (excluding combinations of the Program with other
;; software or hardware) infringes such Recipient's patent(s), then such
;; Recipient's rights granted under Section 2(b) shall terminate as of
;; the date such litigation is filed.
;;
;; All Recipient's rights under this Agreement shall terminate if it
;; fails to comply with any of the material terms or conditions of this
;; Agreement and does not cure such failure in a reasonable period of
;; time after becoming aware of such noncompliance. If all Recipient's
;; rights under this Agreement terminate, Recipient agrees to cease use
;; and distribution of the Program as soon as reasonably
;; practicable. However, Recipient's obligations under this Agreement and
;; any licenses granted by Recipient relating to the Program shall
;; continue and survive.
;;
;; Everyone is permitted to copy and distribute copies of this Agreement,
;; but in order to avoid inconsistency the Agreement is copyrighted and
;; may only be modified in the following manner. The Agreement Steward
;; reserves the right to publish new versions (including revisions) of
;; this Agreement from time to time. No one other than the Agreement
;; Steward has the right to modify this Agreement. The Eclipse Foundation
;; is the initial Agreement Steward. The Eclipse Foundation may assign
;; the responsibility to serve as the Agreement Steward to a suitable
;; separate entity. Each new version of the Agreement will be given a
;; distinguishing version number. The Program (including Contributions)
;; may always be distributed subject to the version of the Agreement
;; under which it was received. In addition, after a new version of the
;; Agreement is published, Contributor may elect to distribute the
;; Program (including its Contributions) under the new version. Except as
;; expressly stated in Sections 2(a) and 2(b) above, Recipient receives
;; no rights or licenses to the intellectual property of any Contributor
;; under this Agreement, whether expressly, by implication, estoppel or
;; otherwise. All rights in the Program not expressly granted under this
;; Agreement are reserved.
;;
;; This Agreement is governed by the laws of the State of New York and
;; the intellectual property laws of the United States of America. No
;; party to this Agreement will bring a legal action under this Agreement
;; more than one year after the cause of action arose. Each party waives
;; its rights to a jury trial in any resulting litigation.
;;
;; 
;;
;; Images distributed under the Creative Commons Attribution + ShareAlike
;; License version 3.0:
;;
;; THE WORK (AS DEFINED BELOW) IS PROVIDED UNDER THE TERMS OF THIS
;; CREATIVE COMMONS PUBLIC LICENSE ("CCPL" OR "LICENSE"). THE WORK IS
;; PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW. ANY USE OF THE
;; WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE OR COPYRIGHT LAW IS
;; PROHIBITED.
;;
;; BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HERE, YOU ACCEPT AND
;; AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. TO THE EXTENT THIS
;; LICENSE MAY BE CONSIDERED TO BE A CONTRACT, THE LICENSOR GRANTS YOU
;; THE RIGHTS CONTAINED HERE IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH
;; TERMS AND CONDITIONS.
;;
;; 1. Definitions
;;
;;     "Adaptation" means a work based upon the Work, or upon the Work
;;     and other pre-existing works, such as a translation, adaptation,
;;     derivative work, arrangement of music or other alterations of a
;;     literary or artistic work, or phonogram or performance and
;;     includes cinematographic adaptations or any other form in which
;;     the Work may be recast, transformed, or adapted including in any
;;     form recognizably derived from the original, except that a work
;;     that constitutes a Collection will not be considered an Adaptation
;;     for the purpose of this License. For the avoidance of doubt, where
;;     the Work is a musical work, performance or phonogram, the
;;     synchronization of the Work in timed-relation with a moving image
;;     ("synching") will be considered an Adaptation for the purpose of
;;     this License.
;;
;;     "Collection" means a collection of literary or artistic works,
;;     such as encyclopedias and anthologies, or performances, phonograms
;;     or broadcasts, or other works or subject matter other than works
;;     listed in Section 1(f) below, which, by reason of the selection
;;     and arrangement of their contents, constitute intellectual
;;     creations, in which the Work is included in its entirety in
;;     unmodified form along with one or more other contributions, each
;;     constituting separate and independent works in themselves, which
;;     together are assembled into a collective whole. A work that
;;     constitutes a Collection will not be considered an Adaptation (as
;;     defined below) for the purposes of this License.
;;
;;     "Creative Commons Compatible License" means a license that is
;;     listed at http://creativecommons.org/compatiblelicenses that has
;;     been approved by Creative Commons as being essentially equivalent
;;     to this License, including, at a minimum, because that license:
;;     (i) contains terms that have the same purpose, meaning and effect
;;     as the License Elements of this License; and, (ii) explicitly
;;     permits the relicensing of adaptations of works made available
;;     under that license under this License or a Creative Commons
;;     jurisdiction license with the same License Elements as this
;;     License.
;;
;;     "Distribute" means to make available to the public the original
;;     and copies of the Work or Adaptation, as appropriate, through sale
;;     or other transfer of ownership.
;;
;;     "License Elements" means the following high-level license
;;     attributes as selected by Licensor and indicated in the title of
;;     this License: Attribution, ShareAlike.
;;
;;     "Licensor" means the individual, individuals, entity or entities
;;     that offer(s) the Work under the terms of this License.
;;
;;     "Original Author" means, in the case of a literary or artistic
;;     work, the individual, individuals, entity or entities who created
;;     the Work or if no individual or entity can be identified, the
;;     publisher; and in addition (i) in the case of a performance the
;;     actors, singers, musicians, dancers, and other persons who act,
;;     sing, deliver, declaim, play in, interpret or otherwise perform
;;     literary or artistic works or expressions of folklore; (ii) in the
;;     case of a phonogram the producer being the person or legal entity
;;     who first fixes the sounds of a performance or other sounds; and,
;;     (iii) in the case of broadcasts, the organization that transmits
;;     the broadcast.
;;
;;     "Work" means the literary and/or artistic work offered under the
;;     terms of this License including without limitation any production
;;     in the literary, scientific and artistic domain, whatever may be
;;     the mode or form of its expression including digital form, such as
;;     a book, pamphlet and other writing; a lecture, address, sermon or
;;     other work of the same nature; a dramatic or dramatico-musical
;;     work; a choreographic work or entertainment in dumb show; a
;;     musical composition with or without words; a cinematographic work
;;     to which are assimilated works expressed by a process analogous to
;;     cinematography; a work of drawing, painting, architecture,
;;     sculpture, engraving or lithography; a photographic work to which
;;     are assimilated works expressed by a process analogous to
;;     photography; a work of applied art; an illustration, map, plan,
;;     sketch or three-dimensional work relative to geography,
;;     topography, architecture or science; a performance; a broadcast; a
;;     phonogram; a compilation of data to the extent it is protected as
;;     a copyrightable work; or a work performed by a variety or circus
;;     performer to the extent it is not otherwise considered a literary
;;     or artistic work.
;;
;;     "You" means an individual or entity exercising rights under this
;;     License who has not previously violated the terms of this License
;;     with respect to the Work, or who has received express permission
;;     from the Licensor to exercise rights under this License despite a
;;     previous violation.
;;
;;     "Publicly Perform" means to perform public recitations of the Work
;;     and to communicate to the public those public recitations, by any
;;     means or process, including by wire or wireless means or public
;;     digital performances; to make available to the public Works in
;;     such a way that members of the public may access these Works from
;;     a place and at a place individually chosen by them; to perform the
;;     Work to the public by any means or process and the communication
;;     to the public of the performances of the Work, including by public
;;     digital performance; to broadcast and rebroadcast the Work by any
;;     means including signs, sounds or images.
;;
;;     "Reproduce" means to make copies of the Work by any means
;;     including without limitation by sound or visual recordings and the
;;     right of fixation and reproducing fixations of the Work, including
;;     storage of a protected performance or phonogram in digital form or
;;     other electronic medium.
;;
;; 2. Fair Dealing Rights. Nothing in this License is intended to reduce,
;; limit, or restrict any uses free from copyright or rights arising from
;; limitations or exceptions that are provided for in connection with the
;; copyright protection under copyright law or other applicable laws.
;;
;; 3. License Grant. Subject to the terms and conditions of this License,
;; Licensor hereby grants You a worldwide, royalty-free, non-exclusive,
;; perpetual (for the duration of the applicable copyright) license to
;; exercise the rights in the Work as stated below:
;;
;;     to Reproduce the Work, to incorporate the Work into one or more
;;     Collections, and to Reproduce the Work as incorporated in the
;;     Collections;
;;
;;     to create and Reproduce Adaptations provided that any such
;;     Adaptation, including any translation in any medium, takes
;;     reasonable steps to clearly label, demarcate or otherwise identify
;;     that changes were made to the original Work. For example, a
;;     translation could be marked "The original work was translated from
;;     English to Spanish," or a modification could indicate "The
;;     original work has been modified.";
;;
;;     to Distribute and Publicly Perform the Work including as
;;     incorporated in Collections; and,
;;
;;     to Distribute and Publicly Perform Adaptations.
;;
;;     For the avoidance of doubt:
;;
;;         Non-waivable Compulsory License Schemes. In those
;;         jurisdictions in which the right to collect royalties through
;;         any statutory or compulsory licensing scheme cannot be waived,
;;         the Licensor reserves the exclusive right to collect such
;;         royalties for any exercise by You of the rights granted under
;;         this License;
;;
;;         Waivable Compulsory License Schemes. In those jurisdictions in
;;         which the right to collect royalties through any statutory or
;;         compulsory licensing scheme can be waived, the Licensor waives
;;         the exclusive right to collect such royalties for any exercise
;;         by You of the rights granted under this License; and,
;;
;;         Voluntary License Schemes. The Licensor waives the right to
;;         collect royalties, whether individually or, in the event that
;;         the Licensor is a member of a collecting society that
;;         administers voluntary licensing schemes, via that society,
;;         from any exercise by You of the rights granted under this
;;         License.
;;
;; The above rights may be exercised in all media and formats whether now
;; known or hereafter devised. The above rights include the right to make
;; such modifications as are technically necessary to exercise the rights
;; in other media and formats. Subject to Section 8(f), all rights not
;; expressly granted by Licensor are hereby reserved.
;;
;; 4. Restrictions. The license granted in Section 3 above is expressly
;; made subject to and limited by the following restrictions:
;;
;;     You may Distribute or Publicly Perform the Work only under the
;;     terms of this License. You must include a copy of, or the Uniform
;;     Resource Identifier (URI) for, this License with every copy of the
;;     Work You Distribute or Publicly Perform. You may not offer or
;;     impose any terms on the Work that restrict the terms of this
;;     License or the ability of the recipient of the Work to exercise
;;     the rights granted to that recipient under the terms of the
;;     License. You may not sublicense the Work. You must keep intact all
;;     notices that refer to this License and to the disclaimer of
;;     warranties with every copy of the Work You Distribute or Publicly
;;     Perform. When You Distribute or Publicly Perform the Work, You may
;;     not impose any effective technological measures on the Work that
;;     restrict the ability of a recipient of the Work from You to
;;     exercise the rights granted to that recipient under the terms of
;;     the License. This Section 4(a) applies to the Work as incorporated
;;     in a Collection, but this does not require the Collection apart
;;     from the Work itself to be made subject to the terms of this
;;     License. If You create a Collection, upon notice from any Licensor
;;     You must, to the extent practicable, remove from the Collection
;;     any credit as required by Section 4(c), as requested. If You
;;     create an Adaptation, upon notice from any Licensor You must, to
;;     the extent practicable, remove from the Adaptation any credit as
;;     required by Section 4(c), as requested.
;;
;;     You may Distribute or Publicly Perform an Adaptation only under
;;     the terms of: (i) this License; (ii) a later version of this
;;     License with the same License Elements as this License; (iii) a
;;     Creative Commons jurisdiction license (either this or a later
;;     license version) that contains the same License Elements as this
;;     License (e.g., Attribution-ShareAlike 3.0 US) ; (iv) a Creative
;;     Commons Compatible License. If you license the Adaptation under
;;     one of the licenses mentioned in (iv), you must comply with the
;;     terms of that license. If you license the Adaptation under the
;;     terms of any of the licenses mentioned in (i), (ii) or (iii) (the
;;     "Applicable License"), you must comply with the terms of the
;;     Applicable License generally and the following provisions: (I) You
;;     must include a copy of, or the URI for, the Applicable License
;;     with every copy of each Adaptation You Distribute or Publicly
;;     Perform; (II) You may not offer or impose any terms on the
;;     Adaptation that restrict the terms of the Applicable License or
;;     the ability of the recipient of the Adaptation to exercise the
;;     rights granted to that recipient under the terms of the Applicable
;;     License; (III) You must keep intact all notices that refer to the
;;     Applicable License and to the disclaimer of warranties with every
;;     copy of the Work as included in the Adaptation You Distribute or
;;     Publicly Perform; (IV) when You Distribute or Publicly Perform the
;;     Adaptation, You may not impose any effective technological
;;     measures on the Adaptation that restrict the ability of a
;;     recipient of the Adaptation from You to exercise the rights
;;     granted to that recipient under the terms of the Applicable
;;     License. This Section 4(b) applies to the Adaptation as
;;     incorporated in a Collection, but this does not require the
;;     Collection apart from the Adaptation itself to be made subject to
;;     the terms of the Applicable License.
;;
;;     If You Distribute, or Publicly Perform the Work or any Adaptations
;;     or Collections, You must, unless a request has been made pursuant
;;     to Section 4(a), keep intact all copyright notices for the Work
;;     and provide, reasonable to the medium or means You are utilizing:
;;     (i) the name of the Original Author (or pseudonym, if applicable)
;;     if supplied, and/or if the Original Author and/or Licensor
;;     designate another party or parties (e.g., a sponsor institute,
;;     publishing entity, journal) for attribution ("Attribution
;;     Parties") in Licensor's copyright notice, terms of service or by
;;     other reasonable means, the name of such party or parties; (ii)
;;     the title of the Work if supplied; (iii) to the extent reasonably
;;     practicable, the URI, if any, that Licensor specifies to be
;;     associated with the Work, unless such URI does not refer to the
;;     copyright notice or licensing information for the Work; and (iv) ,
;;     consistent with Ssection 3(b), in the case of an Adaptation, a
;;     credit identifying the use of the Work in the Adaptation (e.g.,
;;     "French translation of the Work by Original Author," or
;;     "Screenplay based on original Work by Original Author"). The
;;     credit required by this Section 4(c) may be implemented in any
;;     reasonable manner; provided, however, that in the case of a
;;     Adaptation or Collection, at a minimum such credit will appear, if
;;     a credit for all contributing authors of the Adaptation or
;;     Collection appears, then as part of these credits and in a manner
;;     at least as prominent as the credits for the other contributing
;;     authors. For the avoidance of doubt, You may only use the credit
;;     required by this Section for the purpose of attribution in the
;;     manner set out above and, by exercising Your rights under this
;;     License, You may not implicitly or explicitly assert or imply any
;;     connection with, sponsorship or endorsement by the Original
;;     Author, Licensor and/or Attribution Parties, as appropriate, of
;;     You or Your use of the Work, without the separate, express prior
;;     written permission of the Original Author, Licensor and/or
;;     Attribution Parties.
;;
;;     Except as otherwise agreed in writing by the Licensor or as may be
;;     otherwise permitted by applicable law, if You Reproduce,
;;     Distribute or Publicly Perform the Work either by itself or as
;;     part of any Adaptations or Collections, You must not distort,
;;     mutilate, modify or take other derogatory action in relation to
;;     the Work which would be prejudicial to the Original Author's honor
;;     or reputation. Licensor agrees that in those jurisdictions
;;     (e.g. Japan), in which any exercise of the right granted in
;;     Section 3(b) of this License (the right to make Adaptations) would
;;     be deemed to be a distortion, mutilation, modification or other
;;     derogatory action prejudicial to the Original Author's honor and
;;     reputation, the Licensor will waive or not assert, as appropriate,
;;     this Section, to the fullest extent permitted by the applicable
;;     national law, to enable You to reasonably exercise Your right
;;     under Section 3(b) of this License (right to make Adaptations) but
;;     not otherwise.
;;
;; 5. Representations, Warranties and Disclaimer
;;
;; UNLESS OTHERWISE MUTUALLY AGREED TO BY THE PARTIES IN WRITING,
;; LICENSOR OFFERS THE WORK AS-IS AND MAKES NO REPRESENTATIONS OR
;; WARRANTIES OF ANY KIND CONCERNING THE WORK, EXPRESS, IMPLIED,
;; STATUTORY OR OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES OF
;; TITLE, MERCHANTIBILITY, FITNESS FOR A PARTICULAR PURPOSE,
;; NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, ACCURACY,
;; OR THE PRESENCE OF ABSENCE OF ERRORS, WHETHER OR NOT
;; DISCOVERABLE. SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED
;; WARRANTIES, SO SUCH EXCLUSION MAY NOT APPLY TO YOU.
;;
;; 6. Limitation on Liability. EXCEPT TO THE EXTENT REQUIRED BY
;; APPLICABLE LAW, IN NO EVENT WILL LICENSOR BE LIABLE TO YOU ON ANY
;; LEGAL THEORY FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL, PUNITIVE OR
;; EXEMPLARY DAMAGES ARISING OUT OF THIS LICENSE OR THE USE OF THE WORK,
;; EVEN IF LICENSOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
;;
;; 7. Termination
;;
;;     This License and the rights granted hereunder will terminate
;;     automatically upon any breach by You of the terms of this
;;     License. Individuals or entities who have received Adaptations or
;;     Collections from You under this License, however, will not have
;;     their licenses terminated provided such individuals or entities
;;     remain in full compliance with those licenses. Sections 1, 2, 5,
;;     6, 7, and 8 will survive any termination of this License.
;;
;;     Subject to the above terms and conditions, the license granted
;;     here is perpetual (for the duration of the applicable copyright in
;;     the Work). Notwithstanding the above, Licensor reserves the right
;;     to release the Work under different license terms or to stop
;;     distributing the Work at any time; provided, however that any such
;;     election will not serve to withdraw this License (or any other
;;     license that has been, or is required to be, granted under the
;;     terms of this License), and this License will continue in full
;;     force and effect unless terminated as stated above.
;;
;; 8. Miscellaneous
;;
;;     Each time You Distribute or Publicly Perform the Work or a
;;     Collection, the Licensor offers to the recipient a license to the
;;     Work on the same terms and conditions as the license granted to
;;     You under this License.
;;
;;     Each time You Distribute or Publicly Perform an Adaptation,
;;     Licensor offers to the recipient a license to the original Work on
;;     the same terms and conditions as the license granted to You under
;;     this License.
;;
;;     If any provision of this License is invalid or unenforceable under
;;     applicable law, it shall not affect the validity or enforceability
;;     of the remainder of the terms of this License, and without further
;;     action by the parties to this agreement, such provision shall be
;;     reformed to the minimum extent necessary to make such provision
;;     valid and enforceable.
;;
;;     No term or provision of this License shall be deemed waived and no
;;     breach consented to unless such waiver or consent shall be in
;;     writing and signed by the party to be charged with such waiver or
;;     consent.
;;
;;     This License constitutes the entire agreement between the parties
;;     with respect to the Work licensed here. There are no
;;     understandings, agreements or representations with respect to the
;;     Work not specified here. Licensor shall not be bound by any
;;     additional provisions that may appear in any communication from
;;     You. This License may not be modified without the mutual written
;;     agreement of the Licensor and You.
;;
;;     The rights granted under, and the subject matter referenced, in
;;     this License were drafted utilizing the terminology of the Berne
;;     Convention for the Protection of Literary and Artistic Works (as
;;     amended on September 28, 1979), the Rome Convention of 1961, the
;;     WIPO Copyright Treaty of 1996, the WIPO Performances and
;;     Phonograms Treaty of 1996 and the Universal Copyright Convention
;;     (as revised on July 24, 1971). These rights and subject matter
;;     take effect in the relevant jurisdiction in which the License
;;     terms are sought to be enforced according to the corresponding
;;     provisions of the implementation of those treaty provisions in the
;;     applicable national law. If the standard suite of rights granted
;;     under applicable copyright law includes additional rights not
;;     granted under this License, such additional rights are deemed to
;;     be included in the License; this License is not intended to
;;     restrict the license of any rights under applicable law.
