/*
 * Decompiled with CFR 0.152.
 */
package cc.aoeiuv020.ssl;

import cc.aoeiuv020.ssl.CertificationUtils;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcc/aoeiuv020/ssl/TrustManagerUtils;", "", "()V", "logger", "Lorg/slf4j/Logger;", "allowAll", "Ljavax/net/ssl/X509TrustManager;", "include", "certList", "", "Ljava/security/cert/X509Certificate;", "only", "TrustManagerAllowAll", "TrustManagerInclude", "TrustManagerOnly", "ssl"})
public final class TrustManagerUtils {
    private static final Logger logger;
    public static final TrustManagerUtils INSTANCE;

    @NotNull
    public final X509TrustManager allowAll() {
        return new TrustManagerAllowAll();
    }

    @NotNull
    public final X509TrustManager only(@NotNull Set<? extends X509Certificate> certList) {
        Intrinsics.checkParameterIsNotNull(certList, (String)"certList");
        return new TrustManagerOnly(certList);
    }

    @NotNull
    public final X509TrustManager include(@NotNull Set<? extends X509Certificate> certList) {
        Intrinsics.checkParameterIsNotNull(certList, (String)"certList");
        return new TrustManagerInclude(certList);
    }

    private TrustManagerUtils() {
    }

    static {
        TrustManagerUtils trustManagerUtils;
        INSTANCE = trustManagerUtils = new TrustManagerUtils();
        Logger logger = LoggerFactory.getLogger((String)"TrustManagerUtils");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\"TrustManagerUtils\")");
        TrustManagerUtils.logger = logger;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(TrustManagerUtils $this) {
        TrustManagerUtils trustManagerUtils = $this;
        return logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ)\u0010\u000b\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcc/aoeiuv020/ssl/TrustManagerUtils$TrustManagerAllowAll;", "Ljavax/net/ssl/X509TrustManager;", "()V", "checkClientTrusted", "", "chain", "", "Ljava/security/cert/X509Certificate;", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "ssl"})
    private static final class TrustManagerAllowAll
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) {
            if (TrustManagerUtils.access$getLogger$p(INSTANCE).isTraceEnabled() && chain != null) {
                X509Certificate[] $receiver$iv;
                X509Certificate[] x509CertificateArray = $receiver$iv = chain;
                int n = x509CertificateArray.length;
                for (int i = 0; i < n; ++i) {
                    X509Certificate element$iv;
                    X509Certificate it = element$iv = x509CertificateArray[i];
                    TrustManagerUtils.access$getLogger$p(INSTANCE).trace(CertificationUtils.INSTANCE.certificateToBase64(it));
                }
            }
        }

        @Override
        public void checkServerTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) {
            if (TrustManagerUtils.access$getLogger$p(INSTANCE).isTraceEnabled() && chain != null) {
                X509Certificate[] $receiver$iv;
                X509Certificate[] x509CertificateArray = $receiver$iv = chain;
                int n = x509CertificateArray.length;
                for (int i = 0; i < n; ++i) {
                    X509Certificate element$iv;
                    X509Certificate it = element$iv = x509CertificateArray[i];
                    TrustManagerUtils.access$getLogger$p(INSTANCE).trace(CertificationUtils.INSTANCE.certificateToBase64(it));
                }
            }
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J)\u0010\u0006\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\u00020\u00072\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcc/aoeiuv020/ssl/TrustManagerUtils$TrustManagerOnly;", "Ljavax/net/ssl/X509TrustManager;", "certList", "", "Ljava/security/cert/X509Certificate;", "(Ljava/util/Set;)V", "checkClientTrusted", "", "chain", "", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "ssl"})
    private static final class TrustManagerOnly
    implements X509TrustManager {
        private final Set<X509Certificate> certList;

        @Override
        public void checkClientTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) {
            if (TrustManagerUtils.access$getLogger$p(INSTANCE).isTraceEnabled() && chain != null) {
                X509Certificate[] $receiver$iv;
                X509Certificate[] x509CertificateArray = $receiver$iv = chain;
                int n = x509CertificateArray.length;
                for (int i = 0; i < n; ++i) {
                    X509Certificate element$iv;
                    X509Certificate it = element$iv = x509CertificateArray[i];
                    TrustManagerUtils.access$getLogger$p(INSTANCE).trace(CertificationUtils.INSTANCE.certificateToBase64(it));
                }
            }
        }

        @Override
        public void checkServerTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) {
            block8: {
                block7: {
                    X509Certificate[] x509CertificateArray;
                    block6: {
                        X509Certificate[] it;
                        X509Certificate[] $receiver$iv;
                        if (TrustManagerUtils.access$getLogger$p(INSTANCE).isTraceEnabled() && chain != null) {
                            X509Certificate[] x509CertificateArray2 = $receiver$iv = chain;
                            int n = x509CertificateArray2.length;
                            for (int i = 0; i < n; ++i) {
                                X509Certificate[] x509CertificateArray3;
                                it = x509CertificateArray3 = x509CertificateArray2[i];
                                TrustManagerUtils.access$getLogger$p(INSTANCE).trace(CertificationUtils.INSTANCE.certificateToBase64((X509Certificate)it));
                            }
                        }
                        X509Certificate[] x509CertificateArray4 = chain;
                        if (chain == null) break block7;
                        for (X509Certificate[] x509CertificateArray5 : $receiver$iv = x509CertificateArray4) {
                            it = x509CertificateArray5;
                            if (!this.certList.contains(it)) continue;
                            x509CertificateArray = x509CertificateArray5;
                            break block6;
                        }
                        x509CertificateArray = x509CertificateArray4 = null;
                    }
                    if (x509CertificateArray != null) break block8;
                }
                throw (Throwable)new CertificateException("\u8be5\u8bc1\u4e66\u4e0d\u53d7\u4fe1\u4efb\uff0c");
            }
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public TrustManagerOnly(@NotNull Set<? extends X509Certificate> certList) {
            Intrinsics.checkParameterIsNotNull(certList, (String)"certList");
            this.certList = certList;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J)\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J)\u0010\u0011\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0016\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\u001c\u0010\u0019\u001a\u00020\u0013*\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u001cH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcc/aoeiuv020/ssl/TrustManagerUtils$TrustManagerInclude;", "Ljavax/net/ssl/X509TrustManager;", "certList", "", "Ljava/security/cert/X509Certificate;", "(Ljava/util/Set;)V", "acceptedIssuerSet", "", "Ljava/security/Principal;", "tmDefault", "checkClientTrusted", "", "chain", "", "authType", "", "([Ljava/security/cert/X509Certificate;Ljava/lang/String;)V", "checkServerTrusted", "exists", "", "cert", "getAcceptedIssuers", "()[Ljava/security/cert/X509Certificate;", "trust", "trustChain", "causeBy", "", "clazz", "Ljava/lang/Class;", "ssl"})
    private static final class TrustManagerInclude
    implements X509TrustManager {
        private final X509TrustManager tmDefault;
        private final Set<Principal> certList;
        private final Set<X509Certificate> acceptedIssuerSet;

        @Override
        public void checkClientTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) {
            if (TrustManagerUtils.access$getLogger$p(INSTANCE).isTraceEnabled() && chain != null) {
                X509Certificate[] $receiver$iv;
                X509Certificate[] x509CertificateArray = $receiver$iv = chain;
                int n = x509CertificateArray.length;
                for (int i = 0; i < n; ++i) {
                    X509Certificate element$iv;
                    X509Certificate it = element$iv = x509CertificateArray[i];
                    TrustManagerUtils.access$getLogger$p(INSTANCE).trace(CertificationUtils.INSTANCE.certificateToBase64(it));
                }
            }
        }

        @Override
        public void checkServerTrusted(@Nullable X509Certificate[] chain, @Nullable String authType) {
            block10: {
                Object object;
                if (TrustManagerUtils.access$getLogger$p(INSTANCE).isTraceEnabled() && chain != null) {
                    X509Certificate[] $receiver$iv;
                    object = $receiver$iv = chain;
                    int n = ((X509Certificate[])object).length;
                    for (int i = 0; i < n; ++i) {
                        X509Certificate element$iv;
                        X509Certificate x509Certificate = element$iv = object[i];
                        TrustManagerUtils.access$getLogger$p(INSTANCE).trace(CertificationUtils.INSTANCE.certificateToBase64(x509Certificate));
                    }
                }
                try {
                    this.tmDefault.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    String string;
                    if (this.causeBy(e, CertificateExpiredException.class)) {
                        throw (Throwable)e;
                    }
                    X509Certificate[] x509CertificateArray = chain;
                    if (chain != null) {
                        X509Certificate[] x509CertificateArray2;
                        block9: {
                            X509Certificate[] $receiver$iv;
                            for (X509Certificate[] x509CertificateArray3 : $receiver$iv = x509CertificateArray) {
                                X509Certificate[] it = x509CertificateArray3;
                                if (!this.trustChain((X509Certificate)it)) continue;
                                x509CertificateArray2 = x509CertificateArray3;
                                break block9;
                            }
                            x509CertificateArray2 = x509CertificateArray = null;
                        }
                        if (x509CertificateArray2 != null) break block10;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("\u8be5\u8bc1\u4e66\u4e0d\u53d7\u4fe1\u4efb\uff1a");
                    Object object2 = chain;
                    if (chain != null && (object2 = (X509Certificate)ArraysKt.firstOrNull((Object[])object2)) != null) {
                        object = object2;
                        StringBuilder stringBuilder2 = stringBuilder;
                        Object it = object;
                        String string2 = CertificationUtils.INSTANCE.certificateToBase64((X509Certificate)it);
                        stringBuilder = stringBuilder2;
                        string = string2;
                    } else {
                        string = null;
                    }
                    String string3 = stringBuilder.append(string).toString();
                    throw (Throwable)new CertificateException(string3);
                }
            }
        }

        private final boolean causeBy(@NotNull Throwable $receiver, Class<? extends Throwable> clazz) {
            for (Throwable cause = $receiver; cause != null; cause = cause.getCause()) {
                if (clazz.isInstance(cause)) {
                    return true;
                }
                if (!Intrinsics.areEqual((Object)cause.getCause(), (Object)cause)) continue;
                return false;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean trustChain(X509Certificate cert) {
            boolean bl;
            if (this.trust(cert)) return true;
            try {
                X509Certificate issuer = CertificationUtils.INSTANCE.getIssuer(cert);
                if (issuer == null) {
                    return false;
                }
                cert.verify(issuer.getPublicKey());
                boolean bl2 = this.trustChain(issuer);
                bl = bl2;
            }
            catch (Exception e) {
                Logger $receiver$iv = TrustManagerUtils.access$getLogger$p(INSTANCE);
                if (!$receiver$iv.isDebugEnabled()) return false;
                Logger logger = $receiver$iv;
                String string = "\u67e5\u8be2\u8bc1\u4e66\u94fe\u4e0a\u7684\u9881\u53d1\u8005\u5931\u8d25";
                logger.debug(String.valueOf(string), (Throwable)e);
                return false;
            }
            boolean trust = bl;
            if (trust) {
                Principal principal = cert.getSubjectDN();
                Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"cert.subjectDN");
                this.certList.add(principal);
            }
            if (!bl) return false;
            return true;
        }

        private final boolean trust(X509Certificate cert) {
            return this.exists(cert);
        }

        private final boolean exists(X509Certificate cert) {
            return this.certList.contains(cert.getSubjectDN()) || this.certList.contains(cert.getIssuerDN());
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] x509CertificateArray = this.tmDefault.getAcceptedIssuers();
            Intrinsics.checkExpressionValueIsNotNull((Object)x509CertificateArray, (String)"tmDefault.acceptedIssuers");
            return x509CertificateArray;
        }

        /*
         * WARNING - void declaration
         */
        public TrustManagerInclude(@NotNull Set<? extends X509Certificate> certList) {
            Collection<Principal> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Object item$iv$iv2;
            void $receiver$iv$iv2;
            Object it;
            TrustManager element$iv2;
            Iterable $receiver$iv2;
            Object object;
            Object $receiver;
            TrustManagerInclude trustManagerInclude;
            Object object2;
            block5: {
                Intrinsics.checkParameterIsNotNull(certList, (String)"certList");
                object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerInclude = this;
                $receiver = object2;
                ((TrustManagerFactory)$receiver).init((KeyStore)null);
                object = object2;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"TrustManagerFactory.getI\u2026init(null as KeyStore?) }");
                TrustManager[] trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
                Intrinsics.checkExpressionValueIsNotNull((Object)trustManagerArray, (String)"TrustManagerFactory.getI\u2026           .trustManagers");
                object2 = trustManagerArray;
                for (TrustManager element$iv2 : $receiver$iv2) {
                    it = element$iv2;
                    if (!(it instanceof X509TrustManager)) {
                        continue;
                    }
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            object = element$iv2;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
            }
            trustManagerInclude.tmDefault = (X509TrustManager)object;
            $receiver$iv2 = certList;
            trustManagerInclude = this;
            $receiver = $receiver$iv2;
            X509Certificate[] destination$iv$iv = (X509Certificate[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv2) {
                it = (X509Certificate)item$iv$iv2;
                object = destination$iv$iv;
                Principal principal = ((X509Certificate)it).getSubjectDN();
                object.add(principal);
            }
            object = (List)destination$iv$iv;
            object2 = CollectionsKt.toMutableSet((Iterable)((Iterable)object));
            $receiver = object2;
            X509Certificate[] x509CertificateArray = this.tmDefault.getAcceptedIssuers();
            Intrinsics.checkExpressionValueIsNotNull((Object)x509CertificateArray, (String)"tmDefault.acceptedIssuers");
            destination$iv$iv = x509CertificateArray;
            Object object3 = $receiver;
            item$iv$iv2 = $receiver$iv;
            Collection destination$iv$iv2 = new ArrayList(((void)$receiver$iv).length);
            void var8_13 = $receiver$iv$iv;
            int n = ((void)var8_13).length;
            for (int i = 0; i < n; ++i) {
                void it2;
                void item$iv$iv3;
                void var12_17 = item$iv$iv3 = var8_13[i];
                collection = destination$iv$iv2;
                void v2 = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                Principal principal = v2.getSubjectDN();
                collection.add(principal);
            }
            collection = (List)destination$iv$iv2;
            object3.addAll((Collection)collection);
            trustManagerInclude.certList = object = object2;
            Object[] objectArray = this.tmDefault.getAcceptedIssuers();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"tmDefault.acceptedIssuers");
            this.acceptedIssuerSet = ArraysKt.toSet((Object[])objectArray);
        }
    }
}

