/*
 * Decompiled with CFR 0.152.
 */
package cc.aoeiuv020.ssl;

import cc.aoeiuv020.encrypt.EncryptKt;
import cc.aoeiuv020.log.LoggerUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.DERIA5String;
import org.spongycastle.asn1.x509.AccessDescription;
import org.spongycastle.asn1.x509.AuthorityInformationAccess;
import org.spongycastle.asn1.x509.GeneralName;
import org.spongycastle.asn1.x509.X509Extensions;
import org.spongycastle.x509.extension.X509ExtensionUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\bJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcc/aoeiuv020/ssl/CertificationUtils;", "", "()V", "BEGIN_CERTIFICATE", "", "END_CERTIFICATE", "cacheCert", "Ljava/util/WeakHashMap;", "Ljava/security/cert/X509Certificate;", "logger", "Lorg/slf4j/Logger;", "base64ToCertificate", "base64", "certificateBytesToBase64", "bytes", "", "certificateToBase64", "cert", "getIssuer", "getIssuerUrl", "ssl"})
public final class CertificationUtils {
    private static final Logger logger;
    private static final WeakHashMap<String, X509Certificate> cacheCert;
    private static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static final CertificationUtils INSTANCE;

    @Nullable
    public final X509Certificate getIssuer(@NotNull X509Certificate cert) {
        Intrinsics.checkParameterIsNotNull((Object)cert, (String)"cert");
        Principal principal = cert.getSubjectDN();
        Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"cert.subjectDN");
        logger.debug("getIssuer: subject: {}", (Object)principal.getName());
        Principal principal2 = cert.getIssuerDN();
        Intrinsics.checkExpressionValueIsNotNull((Object)principal2, (String)"cert.issuerDN");
        logger.debug("getIssuer: issuer: {}", (Object)principal2.getName());
        try {
            Object object;
            String string = this.getIssuerUrl(cert);
            if (string == null) {
                return null;
            }
            String url = string;
            logger.debug("getIssuer url: {}", (Object)url);
            Map $receiver$iv = cacheCert;
            Object value$iv = $receiver$iv.get(url);
            if (value$iv == null) {
                InputStream inputStream = new URL(url).openStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"URL(url).openStream()");
                X509Certificate answer$iv = INSTANCE.base64ToCertificate(INSTANCE.certificateBytesToBase64(ByteStreamsKt.readBytes((InputStream)inputStream)));
                $receiver$iv.put(url, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Object v = object;
            X509Certificate it = (X509Certificate)v;
            Principal principal3 = cert.getIssuerDN();
            Intrinsics.checkExpressionValueIsNotNull((Object)principal3, (String)"cert.issuerDN");
            logger.debug("getIssuer: cached issuer: {}", (Object)principal3.getName());
            return (X509Certificate)v;
        }
        catch (Exception e) {
            throw (Throwable)new CertificateException("\u83b7\u53d6\u7b7e\u53d1\u8005\u5931\u8d25\uff0c", e);
        }
    }

    private final String getIssuerUrl(X509Certificate cert) {
        String string;
        GeneralName generalName;
        GeneralName generalName2;
        block4: {
            AccessDescription[] $receiver$iv;
            AuthorityInformationAccess aia;
            if (Intrinsics.areEqual((Object)cert.getIssuerDN(), (Object)cert.getSubjectDN())) {
                return null;
            }
            ASN1ObjectIdentifier aSN1ObjectIdentifier = X509Extensions.AuthorityInfoAccess;
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1ObjectIdentifier, (String)"X509Extensions.AuthorityInfoAccess");
            AuthorityInformationAccess authorityInformationAccess = aia = AuthorityInformationAccess.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])cert.getExtensionValue(aSN1ObjectIdentifier.getId())));
            Intrinsics.checkExpressionValueIsNotNull((Object)authorityInformationAccess, (String)"aia");
            AccessDescription[] accessDescriptionArray = authorityInformationAccess.getAccessDescriptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)accessDescriptionArray, (String)"aia.accessDescriptions");
            AccessDescription[] accessDescriptionArray2 = $receiver$iv = accessDescriptionArray;
            int n = accessDescriptionArray2.length;
            for (int i = 0; i < n; ++i) {
                AccessDescription element$iv;
                AccessDescription it;
                AccessDescription accessDescription = it = (element$iv = accessDescriptionArray2[i]);
                Intrinsics.checkExpressionValueIsNotNull((Object)accessDescription, (String)"it");
                if (!Intrinsics.areEqual((Object)accessDescription.getAccessMethod(), (Object)AccessDescription.id_ad_caIssuers)) continue;
                generalName2 = element$iv;
                break block4;
            }
            generalName2 = generalName = null;
        }
        if (generalName2 != null && (generalName = generalName.getAccessLocation()) != null && (generalName = generalName.getName()) != null) {
            GeneralName generalName3;
            GeneralName it = generalName3 = generalName;
            DERIA5String dERIA5String = DERIA5String.getInstance((Object)it);
            Intrinsics.checkExpressionValueIsNotNull((Object)dERIA5String, (String)"DERIA5String.getInstance(it)");
            string = dERIA5String.getString();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String certificateBytesToBase64(@NotNull byte[] bytes) {
        Object object;
        StringBuilder sb;
        Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
        StringBuilder stringBuilder = sb = new StringBuilder();
        String string = BEGIN_CERTIFICATE;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        String encoded = EncryptKt.base64$default((byte[])bytes, (boolean)false, (int)0, (int)0, (int)7, null);
        int start = 0;
        while (start < encoded.length()) {
            object = start + 64;
            int it = ((Number)object).intValue();
            Object object2 = !(it > encoded.length()) ? object : null;
            int end = object2 != null ? ((Integer)object2).intValue() : encoded.length();
            object = sb;
            String string2 = StringsKt.substring((String)encoded, (IntRange)RangesKt.until((int)start, (int)end));
            StringBuilder stringBuilder3 = ((StringBuilder)object).append(string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            start = end;
        }
        StringBuilder stringBuilder4 = sb;
        object = END_CERTIFICATE;
        StringBuilder stringBuilder5 = stringBuilder4.append((String)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        String string3 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sb.toString()");
        return string3;
    }

    @NotNull
    public final X509Certificate base64ToCertificate(@NotNull String base64) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull((Object)base64, (String)"base64");
        String string = base64;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        byte[] byArray2 = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray = byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        Certificate certificate = certificateFactory.generateCertificate(byteArrayInputStream);
        if (certificate == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
        }
        return (X509Certificate)certificate;
    }

    @NotNull
    public final String certificateToBase64(@NotNull X509Certificate cert) {
        Intrinsics.checkParameterIsNotNull((Object)cert, (String)"cert");
        byte[] byArray = cert.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cert.encoded");
        return this.certificateBytesToBase64(byArray);
    }

    private CertificationUtils() {
    }

    static {
        CertificationUtils certificationUtils;
        INSTANCE = certificationUtils = new CertificationUtils();
        CertificationUtils $receiver$iv = certificationUtils;
        LoggerUtils this_$iv = LoggerUtils.INSTANCE;
        logger = this_$iv.getLogger(CertificationUtils.class);
        cacheCert = new WeakHashMap();
    }
}

