/*
 * Decompiled with CFR 0.152.
 */
package cc.aoeiuv020.okhttp;

import cc.aoeiuv020.ssl.TLSSocketFactory;
import cc.aoeiuv020.ssl.TrustManagerUtils;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\b\u001a#\u0010\t\u001a\u00020\b*\u00020\b2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\r\u001a#\u0010\u000e\u001a\u00020\b*\u00020\b2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\f\u00a2\u0006\u0002\u0010\r\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0004\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0010"}, d2={"charset", "", "Lokhttp3/Response;", "get", "Lokhttp3/Call;", "Lokhttp3/OkHttpClient;", "url", "sslAllowAll", "Lokhttp3/OkHttpClient$Builder;", "sslInclude", "certList", "", "Ljava/security/cert/X509Certificate;", "(Lokhttp3/OkHttpClient$Builder;[Ljava/security/cert/X509Certificate;)Lokhttp3/OkHttpClient$Builder;", "sslOnly", "string", "okhttp"})
public final class OkhttpKt {
    @NotNull
    public static final Call get(@NotNull OkHttpClient $receiver, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Request request = new Request.Builder().url(url).build();
        Call call = $receiver.newCall(request);
        Intrinsics.checkExpressionValueIsNotNull((Object)call, (String)"newCall(request)");
        return call;
    }

    @NotNull
    public static final OkHttpClient.Builder sslAllowAll(@NotNull OkHttpClient.Builder $receiver) {
        X509TrustManager x509TrustManager;
        OkHttpClient.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        OkHttpClient.Builder $receiver2 = builder = $receiver;
        X509TrustManager tm = x509TrustManager = TrustManagerUtils.INSTANCE.allowAll();
        $receiver2.sslSocketFactory((SSLSocketFactory)new TLSSocketFactory(tm), tm);
        return builder;
    }

    @NotNull
    public static final OkHttpClient.Builder sslOnly(@NotNull OkHttpClient.Builder $receiver, X509Certificate ... certList) {
        X509TrustManager x509TrustManager;
        OkHttpClient.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)certList, (String)"certList");
        OkHttpClient.Builder $receiver2 = builder = $receiver;
        X509TrustManager tm = x509TrustManager = TrustManagerUtils.INSTANCE.only(ArraysKt.toSet((Object[])certList));
        $receiver2.sslSocketFactory((SSLSocketFactory)new TLSSocketFactory(tm), tm);
        return builder;
    }

    @NotNull
    public static final OkHttpClient.Builder sslInclude(@NotNull OkHttpClient.Builder $receiver, X509Certificate ... certList) {
        X509TrustManager x509TrustManager;
        OkHttpClient.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)certList, (String)"certList");
        OkHttpClient.Builder $receiver2 = builder = $receiver;
        X509TrustManager tm = x509TrustManager = TrustManagerUtils.INSTANCE.include(ArraysKt.toSet((Object[])certList));
        $receiver2.sslSocketFactory((SSLSocketFactory)new TLSSocketFactory(tm), tm);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String string(@NotNull Call $receiver) {
        String string;
        Throwable throwable;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ResponseBody it = object = $receiver.execute().body();
        if (it == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        object = (Closeable)((Object)throwable);
        throwable = null;
        try {
            Object it2 = object;
            String string3 = it2.string();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.string()");
            String string4 = string3;
            string = string4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.execute().body().le\u2026it) }.use { it.string() }");
        return string;
    }

    @Nullable
    public static final String charset(@NotNull Response $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object object = $receiver.body();
        return object != null && (object = object.contentType()) != null && (object = object.charset()) != null ? ((Charset)object).name() : null;
    }

    @NotNull
    public static final String url(@NotNull Response $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.request().url().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.request().url().toString()");
        return string;
    }
}

