/*
 * Decompiled with CFR 0.152.
 */
package cascalog.kryo;

import carbonite.JavaBridge;
import com.esotericsoftware.kryo.Kryo;
import com.twitter.chill.KryoInstantiator;
import com.twitter.chill.config.Config;
import com.twitter.chill.config.ConfigurationException;
import com.twitter.chill.config.ReflectingInstantiator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ClojureKryoInstantiator
extends KryoInstantiator {
    final Config config;
    final ReflectingInstantiator reflectingInst;

    public ClojureKryoInstantiator(Config config) {
        try {
            this.config = config;
            this.reflectingInst = new ReflectingInstantiator(config);
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException(configurationException);
        }
    }

    public Kryo newKryo() {
        try {
            Kryo kryo = this.reflectingInst.newKryo();
            JavaBridge.enhanceRegistry((Kryo)kryo);
            kryo.register(ArrayList.class);
            kryo.register(HashMap.class);
            kryo.register(HashSet.class);
            kryo.setReferences(this.config.getBoolean("cascalog.kryo.setreferences", false));
            kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
            return kryo;
        }
        catch (Exception exception) {
            throw new RuntimeException("unable to create new Kryo: " + exception);
        }
    }
}

