/*
 * Decompiled with CFR 0.152.
 */
package cascalog;

import cascalog.Util;
import cascalog.hadoop.ClojureKryoSerialization;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class KryoService {
    private static final ThreadLocal<Kryo> kryo = new ThreadLocal();
    private static final ThreadLocal<ByteArrayOutputStream> byteStream = new ThreadLocal();
    public static final Logger LOG = Logger.getLogger(KryoService.class);

    public static Kryo getKryo() {
        if (kryo.get() == null) {
            kryo.set(KryoService.freshKryo(KryoService.clojureConf()));
        }
        return kryo.get();
    }

    public static ByteArrayOutputStream getByteStream() {
        if (byteStream.get() == null) {
            byteStream.set(new ByteArrayOutputStream());
        }
        return byteStream.get();
    }

    private static Configuration clojureConf() {
        return (Configuration)Util.bootSimpleFn("hadoop-util.core", "job-conf").invoke(Util.bootSimpleFn("cascalog.cascading.conf", "project-conf").invoke());
    }

    private static Kryo freshKryo(Configuration configuration) {
        Kryo kryo = new ClojureKryoSerialization(configuration).populatedKryo();
        kryo.setRegistrationRequired(false);
        return kryo;
    }

    public static byte[] serialize(Object object) {
        LOG.debug((Object)("Serializing " + object));
        KryoService.getByteStream().reset();
        Output output = new Output((OutputStream)KryoService.getByteStream());
        KryoService.getKryo().writeClassAndObject(output, object);
        output.flush();
        byte[] byArray = KryoService.getByteStream().toByteArray();
        return byArray;
    }

    public static Object deserialize(byte[] byArray) {
        Object object = KryoService.getKryo().readClassAndObject(new Input(byArray));
        LOG.debug((Object)("Deserialized " + object));
        return object;
    }
}

