/*
 * Decompiled with CFR 0.152.
 */
package cascalog;

import cascading.flow.FlowProcess;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntryCollector;
import cascalog.ClojureCombinerBase;
import cascalog.ClojureParallelAgg;
import cascalog.Util;
import cascalog.aggregator.CombinerSpec;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.RT;
import java.util.Arrays;
import java.util.List;

public class ClojureBufferCombiner
extends ClojureCombinerBase {
    private CombinerSpec spec;
    private IFn extract_fn = null;

    public ClojureBufferCombiner(Fields fields, Fields fields2, Fields fields3, Fields fields4, CombinerSpec combinerSpec) {
        super(fields, true, fields2, Arrays.asList(fields3), fields4, Arrays.asList(new ClojureParallelAgg(combinerSpec)), "cascalog.combiner.buffer.size", 200);
        this.spec = combinerSpec;
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall operationCall) {
        super.prepare(flowProcess, operationCall);
        this.extract_fn = Util.deserializeFn(this.spec.presentFn);
    }

    @Override
    protected void write(Tuple tuple, List<Object> list, OperationCall operationCall) {
        TupleEntryCollector tupleEntryCollector = ((FunctionCall)operationCall).getOutputCollector();
        if (list.size() != 1) {
            throw new RuntimeException("Should only have one object in buffer combiner before extraction " + list.size() + ":" + list.toString());
        }
        Object object = list.get(0);
        try {
            for (ISeq iSeq = RT.seq((Object)this.extract_fn.invoke(object)); iSeq != null; iSeq = iSeq.next()) {
                Tuple tuple2 = Util.coerceToTuple(iSeq.first());
                Tuple tuple3 = new Tuple(tuple);
                tuple3.addAll(tuple2);
                tupleEntryCollector.add(tuple3);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

