/*
 * Decompiled with CFR 0.152.
 */
package cascalog.ops;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascalog.KryoService;

public class KryoInsert
extends BaseOperation
implements Function {
    private final byte[] serialized;
    private transient Tuple values;

    public KryoInsert(Fields fields, Object ... objectArray) {
        super(0, fields);
        this.serialized = KryoService.serialize(objectArray);
        if (!fields.isSubstitution() && fields.size() != objectArray.length) {
            throw new IllegalArgumentException("fieldDeclaration must be the same size as the given values");
        }
    }

    public Tuple getTuple() {
        if (this.values == null) {
            Object[] objectArray = (Object[])KryoService.deserialize(this.serialized);
            this.values = new Tuple(objectArray);
        }
        return this.values;
    }

    public void operate(FlowProcess flowProcess, FunctionCall functionCall) {
        functionCall.getOutputCollector().add(new Tuple(this.getTuple()));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KryoInsert)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        KryoInsert kryoInsert = (KryoInsert)((Object)object);
        Tuple tuple = this.getTuple();
        return !(tuple == null ? kryoInsert.getTuple() != null : !tuple.equals((Object)kryoInsert.getTuple()));
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.getTuple() != null ? this.getTuple().hashCode() : 0);
        return n;
    }
}

