/*
 * Decompiled with CFR 0.152.
 */
package cascalog;

import cascading.flow.hadoop.HadoopCoGroupClosure;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.Identity;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.Pipe;
import cascading.pipe.SubAssembly;
import cascading.pipe.joiner.Joiner;
import cascading.pipe.joiner.JoinerClosure;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.collect.HadoopSpillableTupleList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.UUID;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.log4j.Logger;

public class MultiGroupBy
extends SubAssembly {
    public static Logger LOG = Logger.getLogger(MultiGroupBy.class);

    public MultiGroupBy(Pipe pipe, Pipe pipe2, Fields fields, int n, MultiBuffer multiBuffer) {
        Pipe[] pipeArray = new Pipe[]{pipe, pipe2};
        Fields[] fieldsArray = new Fields[]{fields, fields};
        this.init(pipeArray, fieldsArray, n, fields, multiBuffer);
    }

    public MultiGroupBy(Pipe pipe, Fields fields, Pipe pipe2, Fields fields2, int n, Fields fields3, MultiBuffer multiBuffer) {
        Pipe[] pipeArray = new Pipe[]{pipe, pipe2};
        Fields[] fieldsArray = new Fields[]{fields, fields2};
        this.init(pipeArray, fieldsArray, n, fields3, multiBuffer);
    }

    public MultiGroupBy(Pipe[] pipeArray, Fields fields, int n, MultiBuffer multiBuffer) {
        Object[] objectArray = new Fields[pipeArray.length];
        Arrays.fill(objectArray, fields);
        this.init(pipeArray, (Fields[])objectArray, n, fields, multiBuffer);
    }

    public MultiGroupBy(Pipe[] pipeArray, Fields[] fieldsArray, int n, Fields fields, MultiBuffer multiBuffer) {
        this.init(pipeArray, fieldsArray, n, fields, multiBuffer);
    }

    protected void init(Pipe[] pipeArray, Fields[] fieldsArray, int n, Fields fields, MultiBuffer multiBuffer) {
        for (int i = 0; i < pipeArray.length; ++i) {
            pipeArray[i] = new Pipe(UUID.randomUUID().toString(), pipeArray[i]);
            pipeArray[i] = new Each(pipeArray[i], Fields.ALL, (Function)new Identity(), Fields.RESULTS);
        }
        Fields fields2 = Fields.join((Fields[])new Fields[]{fields, ((BaseOperation)multiBuffer).getFieldDeclaration()});
        if (fields2.size() > n) {
            throw new IllegalArgumentException("Can't have output more than sum of input pipes since this is a hack!");
        }
        Fields fields3 = new Fields(new Comparable[0]);
        fields3 = fields3.append(fields2);
        int n2 = 0;
        while (fields3.size() < n) {
            fields3 = fields3.append(new Fields(new Comparable[]{"__" + n2}));
            ++n2;
        }
        CoGroup coGroup = new CoGroup(pipeArray, fieldsArray, fields3, (Joiner)new MultiGroupJoiner(n, multiBuffer));
        coGroup = new Each((Pipe)coGroup, fields2, (Function)new Identity());
        this.setTails(new Pipe[]{coGroup});
    }

    protected static class MultiGroupJoiner
    implements Joiner {
        protected MultiBufferExecutor _buffer;

        public MultiGroupJoiner(int n, MultiBuffer multiBuffer) {
            this._buffer = new MultiBufferExecutor(multiBuffer, n);
        }

        public Iterator<Tuple> getIterator(JoinerClosure joinerClosure) {
            this._buffer.setContext(joinerClosure);
            this._buffer.operate();
            final Iterator iterator = this._buffer.getResults().iterator();
            return new Iterator<Tuple>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Tuple next() {
                    return new Tuple((Tuple)iterator.next());
                }

                @Override
                public void remove() {
                    iterator.remove();
                }
            };
        }

        public int numJoins() {
            return -1;
        }
    }

    public static class MultiBufferExecutor
    implements Serializable {
        private MultiBuffer _buffer;
        private MultiBufferContext _context;
        private int _pipeFieldsSum;
        private JoinerClosure _closure;

        public MultiBufferExecutor(MultiBuffer multiBuffer, int n) {
            this._buffer = multiBuffer;
            this._pipeFieldsSum = n;
        }

        public void setContext(JoinerClosure joinerClosure) {
            this._closure = joinerClosure;
            this._context = new MultiBufferContext(joinerClosure, this._pipeFieldsSum);
        }

        public HadoopSpillableTupleList getResults() {
            return this._context.getResults();
        }

        public void operate() {
            ((BaseOperation)this._buffer).prepare(this._closure.getFlowProcess(), null);
            this._buffer.operate(this._context);
            ((BaseOperation)this._buffer).cleanup(this._closure.getFlowProcess(), null);
        }
    }

    public static class MultiBufferContext {
        JoinerClosure _closure;
        HadoopSpillableTupleList _results = new HadoopSpillableTupleList(10000, (CompressionCodec)null, null);
        int _pipeFieldsSum;

        public MultiBufferContext(JoinerClosure joinerClosure, int n) {
            this._closure = joinerClosure;
            this._pipeFieldsSum = n;
        }

        public int size() {
            return this._closure.size();
        }

        public void emit(Tuple tuple) {
            Tuple tuple2 = new Tuple(((HadoopCoGroupClosure)this._closure).getGrouping());
            tuple2.addAll(tuple);
            while (tuple2.size() < this._pipeFieldsSum) {
                tuple2.add((Comparable)Integer.valueOf(0));
            }
            this._results.add(tuple2);
        }

        public Iterator<Tuple> getArgumentsIterator(int n) {
            return this._closure.getIterator(n);
        }

        public HadoopSpillableTupleList getResults() {
            return this._results;
        }
    }

    public static interface MultiBuffer
    extends Serializable {
        public void operate(MultiBufferContext var1);
    }
}

