/*
 * Decompiled with CFR 0.152.
 */
package cascalog;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascalog.Util;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import java.util.Map;

public class ClojureCascadingBase
extends BaseOperation {
    private byte[] serializedFn;
    protected IFn fn;
    protected IFn cleanupFn;

    public void initialize(IFn iFn) {
        this.serializedFn = Util.serializeFn(iFn);
    }

    public ClojureCascadingBase(IFn iFn) {
        this.initialize(iFn);
    }

    public ClojureCascadingBase(Fields fields, IFn iFn) {
        super(fields);
        this.initialize(iFn);
    }

    public void prepare(FlowProcess flowProcess, OperationCall operationCall) {
        IFn iFn = Util.deserializeFn(this.serializedFn);
        Boolean bl = (Boolean)Util.bootSimpleFn("cascalog.logic.def", "prepared?").invoke((Object)iFn);
        if (bl.booleanValue()) {
            Object object = iFn.invoke((Object)flowProcess, (Object)operationCall);
            if (object instanceof Map) {
                Map map = (Map)object;
                this.fn = (IFn)map.get(Keyword.intern((String)"operate"));
                this.cleanupFn = (IFn)map.get(Keyword.intern((String)"cleanup"));
            } else {
                this.fn = (IFn)object;
                this.cleanupFn = null;
            }
        } else {
            this.fn = iFn;
            this.cleanupFn = null;
        }
    }

    protected Object applyFunction(ISeq iSeq) {
        return this.fn.applyTo(iSeq);
    }

    protected Object invokeFunction(Object object) {
        return this.fn.invoke(object);
    }

    protected Object invokeFunction() {
        return this.fn.invoke();
    }

    public void cleanup(FlowProcess flowProcess, OperationCall operationCall) {
        super.cleanup(flowProcess, operationCall);
        if (this.cleanupFn != null) {
            this.cleanupFn.invoke();
        }
    }
}

