/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.splunk;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplunkUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SplunkUtil.class);

    public static Map<String, Object> loadSplunkRC() throws IOException {
        Path path;
        String home = System.getenv("SPLUNK_RC_HOME");
        if (home == null) {
            home = System.getProperty("user.home");
        }
        if (!Files.exists(path = Paths.get(home + File.separator + ".splunkrc", new String[0]), new LinkOption[0])) {
            return Collections.emptyMap();
        }
        LOG.info("reading .splunkrc from: {}", (Object)path);
        Map<String, Object> params = Files.readAllLines(path).stream().map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("#")).map(line -> line.split("=")).filter(pair -> ((String[])pair).length == 2).filter(pair -> pair[1] != null).collect(Collectors.toMap(pair -> pair[0], pair -> pair[1]));
        params.computeIfPresent("port", (k, v) -> Integer.parseInt(v.toString()));
        return params;
    }
}

