/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.splunk;

import cascading.flow.FlowProcess;
import cascading.local.tap.splunk.SplunkScheme;
import cascading.scheme.SinkCall;
import cascading.scheme.local.TextDelimited;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.type.DateType;
import com.splunk.JobExportArgs;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.Properties;
import java.util.TimeZone;

public class SplunkCSV
extends TextDelimited
implements SplunkScheme {
    public static final DateType DATE_TYPE = new DateType("yyyy-MM-dd HH:mm:ss.SSS z", TimeZone.getTimeZone("UTC"));
    public static final Fields _TIME = new Fields((Comparable)((Object)"_time"), (Type)DATE_TYPE);
    public static final Fields _SERIAL = new Fields((Comparable)((Object)"_serial"), Long.class);
    public static final Fields SOURCE = new Fields((Comparable)((Object)"source"), String.class);
    public static final Fields SOURCETYPE = new Fields((Comparable)((Object)"sourcetype"), String.class);
    public static final Fields HOST = new Fields((Comparable)((Object)"host"), String.class);
    public static final Fields INDEX = new Fields((Comparable)((Object)"index"), String.class);
    public static final Fields SPLUNK_SERVER = new Fields((Comparable)((Object)"splunk_server"), String.class);
    public static final Fields _RAW = new Fields((Comparable)((Object)"_raw"), String.class);
    public static final Fields _INDEXTIME = new Fields((Comparable)((Object)"_indextime"), Long.TYPE);
    public static final Fields _SUBSECOND = new Fields((Comparable)((Object)"_subsecond"), Float.TYPE);
    public static final Fields TIMESTARTPOS = new Fields((Comparable)((Object)"timestartpos"), Long.TYPE);
    public static final Fields TIMEENDPOS = new Fields((Comparable)((Object)"timeendpos"), Long.TYPE);
    public static final Fields DEFAULTS = Fields.NONE.append(_SERIAL).append(_TIME).append(SOURCE).append(SOURCETYPE).append(HOST).append(INDEX).append(SPLUNK_SERVER).append(_RAW);
    public static final Fields KNOWN = DEFAULTS.append(_INDEXTIME).append(_SUBSECOND).append(TIMESTARTPOS).append(TIMEENDPOS);

    public SplunkCSV() {
        super(Fields.ALL, true, false, ",", "\"", null);
    }

    public SplunkCSV(Fields fields) {
        super(fields, true, false, ",", "\"", null);
    }

    public boolean isSink() {
        return false;
    }

    public void sink(FlowProcess<? extends Properties> flowProcess, SinkCall<PrintWriter, OutputStream> sinkCall) {
        throw new UnsupportedOperationException("sinking is not supported");
    }

    public void sourceConfInit(FlowProcess<? extends Properties> flowProcess, Tap<Properties, InputStream, OutputStream> tap, Properties conf) {
        super.sourceConfInit(flowProcess, tap, conf);
        JobExportArgs args = new JobExportArgs();
        args.setOutputMode(JobExportArgs.OutputMode.CSV);
        if (this.getSourceFields().isDefined()) {
            Fields sourceFields = this.getSourceFields();
            String[] fields = new String[sourceFields.size()];
            for (int i = 0; i < sourceFields.size(); ++i) {
                fields[i] = sourceFields.get(i).toString();
            }
            args.setFieldList(fields);
        }
        conf.put("args", args);
    }

    public Fields retrieveSourceFields(FlowProcess<? extends Properties> process, Tap tap) {
        return this.getSourceFields();
    }
}

