/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.splunk;

import cascading.flow.FlowProcess;
import cascading.local.tap.splunk.SplunkScheme;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeIterator;
import com.splunk.JobExportArgs;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;

public abstract class SplunkTap
extends Tap<Properties, InputStream, OutputStream> {
    private ServiceArgs serviceArgs;
    private Service service;
    private JobExportArgs exportArgs;

    public SplunkTap(SplunkScheme scheme, String host, int port) {
        super((Scheme)scheme, SinkMode.UPDATE);
        ServiceArgs serviceArgs = new ServiceArgs();
        serviceArgs.setHost(host);
        serviceArgs.setPort(port);
        this.serviceArgs = serviceArgs;
    }

    public SplunkTap(SplunkScheme scheme) {
        super((Scheme)scheme, SinkMode.UPDATE);
    }

    public SplunkTap(SplunkScheme scheme, SinkMode sinkMode) {
        super((Scheme)scheme, sinkMode);
    }

    public SplunkTap(SplunkScheme scheme, ServiceArgs serviceArgs, SinkMode sinkMode) {
        super((Scheme)scheme, sinkMode);
        this.serviceArgs = serviceArgs;
    }

    public SplunkTap(SplunkScheme scheme, ServiceArgs serviceArgs) {
        super((Scheme)scheme, SinkMode.UPDATE);
        this.serviceArgs = serviceArgs;
    }

    public SplunkTap(SplunkScheme scheme, ServiceArgs serviceArgs, JobExportArgs exportArgs, SinkMode sinkMode) {
        super((Scheme)scheme, sinkMode);
        this.serviceArgs = serviceArgs;
        this.exportArgs = exportArgs;
    }

    public SplunkTap(SplunkScheme scheme, ServiceArgs serviceArgs, JobExportArgs exportArgs) {
        super((Scheme)scheme, SinkMode.UPDATE);
        this.serviceArgs = serviceArgs;
        this.exportArgs = exportArgs;
    }

    public SplunkTap(SplunkScheme scheme, Service service, JobExportArgs exportArgs, SinkMode sinkMode) {
        super((Scheme)scheme, sinkMode);
        this.service = service;
        this.exportArgs = exportArgs;
    }

    public SplunkTap(SplunkScheme scheme, Service service, JobExportArgs exportArgs) {
        super((Scheme)scheme, SinkMode.UPDATE);
        this.service = service;
        this.exportArgs = exportArgs;
    }

    protected Service getService() {
        if (this.service != null) {
            return this.service;
        }
        this.service = Service.connect((Map)this.serviceArgs);
        return this.service;
    }

    public String getIdentifier() {
        URI splunk;
        try {
            splunk = new URI(this.getService().getScheme().equals("https") ? "splunks" : "splunk", null, this.getService().getHost(), this.getService().getPort(), this.getSplunkPath(), this.getSplunkQuery(), null);
        }
        catch (URISyntaxException exception) {
            throw new TapException("could not create identifier", (Throwable)exception);
        }
        return splunk.toString();
    }

    protected abstract String getSplunkQuery();

    protected abstract String getSplunkPath();

    public TupleEntryIterator openForRead(FlowProcess<? extends Properties> flowProcess, InputStream inputStream) {
        Properties properties = new Properties();
        this.sourceConfInit(flowProcess, properties);
        JobExportArgs exportArgs = new JobExportArgs();
        if (this.exportArgs != null) {
            exportArgs.putAll((Map)this.exportArgs);
        }
        if (properties.get("args") != null) {
            exportArgs.putAll((Map)properties.get("args"));
        }
        if (!exportArgs.containsKey((Object)"timeout")) {
            exportArgs.setTimeout(60);
        }
        String search = this.getSearch();
        inputStream = this.getService().export(search, exportArgs);
        return new TupleEntrySchemeIterator(flowProcess, (Tap)this, this.getScheme(), (Object)inputStream, this::getIdentifier);
    }

    protected abstract String getSearch();
}

