/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.aws.s3;

import cascading.local.tap.aws.s3.S3Checkpointer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class S3FileCheckpointer
implements S3Checkpointer {
    Map<String, String> seenKeys = new LinkedHashMap<String, String>();
    Path path = S3FileCheckpointer.makeHidden(S3FileCheckpointer.homeDir());
    Function<String, String> filename = bucket -> bucket + ".txt";

    public static Path homeDir() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    public static Path currentDir() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    public static Path makeHidden(Path path) {
        return path.resolve(".cascading").resolve("s3tap-checkpoints");
    }

    public S3FileCheckpointer() {
    }

    public S3FileCheckpointer(String path) {
        this(Paths.get(path, new String[0]));
    }

    public S3FileCheckpointer(Path path) {
        this.path = path;
    }

    public S3FileCheckpointer(Function<String, String> filename) {
        this.filename = filename;
    }

    public S3FileCheckpointer(Path path, Function<String, String> filename) {
        this.path = path;
        this.filename = filename;
    }

    @Override
    public String getLastKey(String bucketName) {
        Path input = this.getPathFor(bucketName);
        if (!Files.exists(input, new LinkOption[0])) {
            return null;
        }
        try {
            return Files.lines(input).findFirst().orElse(null);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    private Path getPathFor(String bucketName) {
        return this.path.resolve(this.filename.apply(bucketName));
    }

    @Override
    public void setLastKey(String bucketName, String key) {
        this.seenKeys.put(bucketName, key);
    }

    @Override
    public void commit() {
        for (Map.Entry<String, String> entry : this.seenKeys.entrySet()) {
            try {
                Path bucketPath = this.getPathFor(entry.getKey());
                Files.createDirectories(bucketPath.getParent(), new FileAttribute[0]);
                Files.write(bucketPath, Collections.singleton(entry.getValue()), new OpenOption[0]);
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }
        this.seenKeys.clear();
    }
}

