/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.neo4j;

import cascading.flow.FlowProcess;
import cascading.local.tap.neo4j.JSONGraphSpec;
import cascading.local.tap.neo4j.Neo4jJSONStatement;
import cascading.local.tap.neo4j.Neo4jScheme;
import cascading.local.tap.neo4j.Neo4jStatement;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Properties;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jJSONScheme
extends Neo4jScheme {
    private static final Logger LOG = LoggerFactory.getLogger(Neo4jJSONScheme.class);
    private final JSONGraphSpec graphSpec;

    public Neo4jJSONScheme(Fields sinkFields, JSONGraphSpec graphSpec) {
        super(Fields.UNKNOWN, sinkFields);
        this.graphSpec = graphSpec;
        if (!sinkFields.isDeclarator() || sinkFields.size() > 1) {
            throw new IllegalArgumentException("sink fields must be size one, got: " + sinkFields.print());
        }
    }

    public boolean isSource() {
        return false;
    }

    public void sourceConfInit(FlowProcess<? extends Properties> flowProcess, Tap<Properties, Void, Session> tap, Properties conf) {
        throw new UnsupportedOperationException();
    }

    public boolean source(FlowProcess<? extends Properties> flowProcess, SourceCall<Neo4jScheme.Context, Void> sourceCall) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void sinkConfInit(FlowProcess<? extends Properties> flowProcess, Tap<Properties, Void, Session> tap, Properties conf) {
    }

    public void sinkPrepare(FlowProcess<? extends Properties> flowProcess, SinkCall<Neo4jScheme.Context, Session> sinkCall) throws IOException {
        sinkCall.setContext(new Neo4jScheme.Context<JsonNode>(this, new Neo4jJSONStatement(this.graphSpec)));
    }

    public void sink(FlowProcess<? extends Properties> flowProcess, SinkCall<Neo4jScheme.Context, Session> sinkCall) throws IOException {
        Session session = (Session)sinkCall.getOutput();
        Neo4jStatement statement = ((Neo4jScheme.Context)sinkCall.getContext()).statement;
        TupleEntry entry = sinkCall.getOutgoingEntry();
        JsonNode node = (JsonNode)entry.getObject(0);
        session.writeTransaction(tx -> {
            StatementResult result = statement.runStatement(tx, node);
            if (LOG.isDebugEnabled()) {
                LOG.debug("cypher results: {}", (Object)result.summary());
            }
            return true;
        });
    }
}

