/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.neo4j;

import cascading.local.tap.neo4j.GraphSpec;
import cascading.local.tap.neo4j.JSONUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import heretical.pointer.path.Pointer;
import heretical.pointer.path.json.JSONNestedPointerCompiler;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class JSONGraphSpec
implements GraphSpec {
    String nodeLabel;
    Map<String, Ref> properties = new LinkedHashMap<String, Ref>();
    Set<EdgeSpec> edges = new LinkedHashSet<EdgeSpec>();
    String valuesPointer = null;
    Function<JsonNode, JsonNode> valueRef = n -> n;

    @JsonCreator
    public JSONGraphSpec(@JsonProperty(value="nodeLabel") String nodeLabel) {
        this.nodeLabel = nodeLabel;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public boolean hasNodeLabel() {
        return this.getNodeLabel() != null;
    }

    @JsonGetter(value="properties")
    public Map<String, Ref> getRefProperties() {
        return this.properties;
    }

    @JsonIgnore
    public Map<String, Function<JsonNode, Object>> getProperties() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Ref)e.getValue()).function));
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    public JSONGraphSpec addProperty(String property, Object value) {
        return this.addProperty(property, new Ref(value));
    }

    public JSONGraphSpec addProperty(String property, String fromPointer, Object defaultValue) {
        return this.addProperty(property, new Ref(fromPointer, defaultValue));
    }

    public JSONGraphSpec addProperty(String property, Function<JsonNode, Object> function) {
        return this.addProperty(property, new Ref(function));
    }

    @JsonSetter(value="properties")
    public JSONGraphSpec addProperty(String property, Ref ref) {
        if (this.properties.put(property, ref) != null) {
            throw new IllegalArgumentException("match property: " + property + " already exists");
        }
        return this;
    }

    @JsonIgnore
    public Function<JsonNode, JsonNode> getValuesPointer() {
        return this.valueRef;
    }

    @JsonGetter(value="valuesPointer")
    public String getRefValuesPointer() {
        return this.valuesPointer;
    }

    @JsonSetter(value="valuesPointer")
    public JSONGraphSpec setValuesPointer(String valuesPointer) {
        this.valuesPointer = valuesPointer;
        this.valueRef = n -> n.at(JsonPointer.compile((String)valuesPointer));
        return this;
    }

    @JsonGetter(value="edges")
    public Set<EdgeSpec> getEdges() {
        return this.edges;
    }

    public boolean hasEdges() {
        return !this.getEdges().isEmpty();
    }

    public EdgeSpec addEdge() {
        return this.addEdge((String)null);
    }

    public EdgeSpec addEdge(String edgeType) {
        return this.addEdge(new EdgeSpec(edgeType));
    }

    public EdgeSpec addEdge(EdgeSpec edgeSpec) {
        this.edges.add(edgeSpec);
        return edgeSpec;
    }

    @JsonSetter(value="edges")
    public void setEdges(Set<EdgeSpec> edges) {
        this.edges.addAll(edges);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JSONGraphSpec)) {
            return false;
        }
        JSONGraphSpec graphSpec = (JSONGraphSpec)o;
        return Objects.equals(this.nodeLabel, graphSpec.nodeLabel) && Objects.equals(this.properties, graphSpec.properties) && Objects.equals(this.edges, graphSpec.edges) && Objects.equals(this.valuesPointer, graphSpec.valuesPointer);
    }

    public int hashCode() {
        return Objects.hash(this.nodeLabel, this.properties, this.edges, this.valuesPointer);
    }

    public static class EdgeSpec {
        String edgeType;
        String targetLabel;
        Map<String, Ref> targetProperties = new LinkedHashMap<String, Ref>();

        public EdgeSpec() {
        }

        public EdgeSpec(String edgeType) {
            this.edgeType = edgeType;
        }

        @JsonCreator
        public EdgeSpec(@JsonProperty(value="edgeType") String edgeType, @JsonProperty(value="targetLabel") String targetLabel) {
            this(edgeType);
            this.targetLabel = targetLabel;
        }

        public boolean hasEdgeType() {
            return this.getEdgeType() != null;
        }

        public String getEdgeType() {
            return this.edgeType;
        }

        public boolean hasTargetLabel() {
            return this.getTargetLabel() != null;
        }

        public String getTargetLabel() {
            return this.targetLabel;
        }

        public boolean hasTargetProperties() {
            return !this.targetProperties.isEmpty();
        }

        @JsonGetter(value="targetProperties")
        public Map<String, Ref> getRefTargetProperties() {
            return this.targetProperties;
        }

        public Map<String, Function<JsonNode, Object>> getTargetProperties() {
            return this.targetProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Ref)e.getValue()).function));
        }

        public EdgeSpec addTargetLabel(String targetLabel) {
            this.targetLabel = targetLabel;
            return this;
        }

        public EdgeSpec addTargetProperty(String property, Object value) {
            return this.addTargetProperty(property, new Ref(value));
        }

        public EdgeSpec addTargetProperty(String property, String fromPointer, Object defaultValue) {
            return this.addTargetProperty(property, new Ref(fromPointer, defaultValue));
        }

        public EdgeSpec addTargetProperty(String property, Function<JsonNode, Object> function) {
            return this.addTargetProperty(property, new Ref(function));
        }

        @JsonSetter(value="targetProperties")
        public EdgeSpec addTargetProperty(String property, Ref ref) {
            if (this.targetProperties.put(property, ref) != null) {
                throw new IllegalArgumentException("match property: " + property + ", already exists");
            }
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EdgeSpec)) {
                return false;
            }
            EdgeSpec edgeSpec = (EdgeSpec)o;
            return Objects.equals(this.edgeType, edgeSpec.edgeType) && Objects.equals(this.targetLabel, edgeSpec.targetLabel) && Objects.equals(this.targetProperties, edgeSpec.targetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.edgeType, this.targetLabel, this.targetProperties);
        }
    }

    public static class Ref {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        String fromPointer;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        Object defaultValue;
        @JsonIgnore
        Function<JsonNode, Object> function;

        public Ref(Function<JsonNode, Object> function) {
            this.function = function;
        }

        public Ref(Object defaultValue) {
            this(null, defaultValue);
        }

        @JsonCreator
        public Ref(@JsonProperty(value="fromPointer") String fromPointer, @JsonProperty(value="defaultValue") Object defaultValue) {
            this.fromPointer = fromPointer;
            this.defaultValue = defaultValue;
            if (fromPointer != null) {
                Pointer pointer = JSONNestedPointerCompiler.COMPILER.compile(fromPointer);
                this.function = n -> pointer.at(n) == null ? defaultValue : JSONUtil.at((Pointer<JsonNode>)pointer, n);
            } else {
                this.function = n -> defaultValue;
            }
        }

        public String getFromPointer() {
            return this.fromPointer;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Function<JsonNode, Object> getFunction() {
            return this.function;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ref)) {
                return false;
            }
            Ref ref = (Ref)o;
            return Objects.equals(this.fromPointer, ref.fromPointer) && Objects.equals(this.defaultValue, ref.defaultValue) && Objects.equals(this.function, ref.function);
        }

        public int hashCode() {
            return Objects.hash(this.fromPointer, this.defaultValue, this.function);
        }
    }
}

