/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.neo4j;

import iot.jcypher.database.util.QParamsUtil;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.writer.CypherWriter;
import iot.jcypher.query.writer.Format;
import iot.jcypher.query.writer.QueryParam;
import iot.jcypher.query.writer.WriterContext;
import iot.jcypher.util.Util;
import java.util.Map;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Neo4jStatement<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Neo4jStatement.class);

    public abstract JcQuery getStatement(T var1);

    public StatementResult runStatement(Transaction tx, T node) {
        JcQuery query = this.getStatement(node);
        if (LOG.isDebugEnabled()) {
            LOG.debug("cypher: {}", (Object)Util.toCypher((JcQuery)query, (Format)Format.NONE));
        }
        WriterContext context = new WriterContext();
        QueryParam.setExtractParams((boolean)query.isExtractParams(), (WriterContext)context);
        CypherWriter.toCypherExpression((JcQuery)query, (WriterContext)context);
        String cypher = context.buffer.toString();
        Map paramsMap = QParamsUtil.createQueryParams((WriterContext)context);
        return tx.run(cypher, paramsMap);
    }
}

