/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.neo4j;

import cascading.flow.FlowProcess;
import cascading.local.tap.neo4j.Neo4jScheme;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeCollector;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.driver.v1.Session;

public class Neo4jTap
extends Tap<Properties, Void, Session> {
    public static final String NEO_4_J_USERNAME = "neo4j.username";
    public static final String NEO_4_J_PASSWORD = "neo4j.password";
    private final Properties defaultProperties;
    private final URI identifier;

    public Neo4jTap(Properties defaultProperties, Neo4jScheme scheme, URI identifier) {
        super((Scheme)scheme, SinkMode.UPDATE);
        this.defaultProperties = new Properties(defaultProperties);
        this.identifier = identifier;
    }

    protected Driver getDriver(FlowProcess<? extends Properties> flowProcess) {
        AuthToken authTokens = AuthTokens.none();
        String user = flowProcess.getStringProperty(NEO_4_J_USERNAME, this.defaultProperties.getProperty(NEO_4_J_USERNAME, System.getenv("NEO4J_USER")));
        String password = flowProcess.getStringProperty(NEO_4_J_PASSWORD, this.defaultProperties.getProperty(NEO_4_J_PASSWORD, System.getenv("NEO4J_PASSWORD")));
        if (user != null) {
            authTokens = AuthTokens.basic((String)user, (String)password);
        }
        return GraphDatabase.driver((String)this.getIdentifier(), (AuthToken)authTokens);
    }

    public String getIdentifier() {
        return this.identifier.toString();
    }

    public TupleEntryIterator openForRead(FlowProcess<? extends Properties> flowProcess, Void aVoid) throws IOException {
        return null;
    }

    public TupleEntryCollector openForWrite(FlowProcess<? extends Properties> flowProcess, Session session) throws IOException {
        if (session == null) {
            session = this.getDriver(flowProcess).session();
        }
        return new TupleEntrySchemeCollector(flowProcess, (Tap)this, this.getScheme(), (Object)session, this.getIdentifier());
    }

    public boolean createResource(Properties conf) throws IOException {
        return true;
    }

    public boolean deleteResource(Properties conf) throws IOException {
        return true;
    }

    public boolean resourceExists(Properties conf) throws IOException {
        return true;
    }

    public long getModifiedTime(Properties conf) throws IOException {
        return 0L;
    }
}

