/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.neo4j;

import cascading.local.tap.neo4j.JSONGraphSpec;
import cascading.local.tap.neo4j.Neo4jStatement;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import iot.jcypher.database.internal.PlannerStrategy;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.api.IClause;
import iot.jcypher.query.api.pattern.Node;
import iot.jcypher.query.api.pattern.Relation;
import iot.jcypher.query.factories.clause.MERGE;
import iot.jcypher.query.factories.clause.ON_CREATE;
import iot.jcypher.query.values.JcNode;
import iot.jcypher.query.values.JcProperty;
import iot.jcypher.query.values.JcRelation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jJSONStatement
extends Neo4jStatement<JsonNode> {
    private static final Logger LOG = LoggerFactory.getLogger(Neo4jJSONStatement.class);
    JSONGraphSpec graphSpec;
    private ObjectMapper objectMapper = new ObjectMapper();

    public Neo4jJSONStatement(JSONGraphSpec graphSpec) {
        this.graphSpec = graphSpec;
    }

    @Override
    public JcQuery getStatement(JsonNode json) {
        ArrayList<Object> clauses = new ArrayList<Object>();
        JcNode head = new JcNode("n");
        Node merge = MERGE.node((JcNode)head);
        if (this.graphSpec.hasNodeLabel()) {
            merge.label(this.graphSpec.getNodeLabel());
        }
        if (this.graphSpec.hasProperties()) {
            this.applyProperties(json, merge, this.graphSpec.getProperties(), false);
        }
        clauses.add(merge);
        Map<String, Object> propertyValues = this.asProperties(this.graphSpec.getValuesPointer().apply(json));
        for (Map.Entry<String, Object> entry : propertyValues.entrySet()) {
            clauses.add(ON_CREATE.SET((JcProperty)head.property(entry.getKey())).to(entry.getValue()));
        }
        if (this.graphSpec.hasEdges()) {
            Set<JSONGraphSpec.EdgeSpec> edges = this.graphSpec.getEdges();
            int count = 0;
            for (JSONGraphSpec.EdgeSpec edge : edges) {
                int propertiesFound;
                JcNode target = new JcNode("t".concat(Integer.toString(count)));
                Node targetMerge = MERGE.node((JcNode)target);
                if (!edge.hasTargetLabel() && !edge.hasTargetProperties()) {
                    LOG.debug("edge, {}, has no match patterns", (Object)edge.getEdgeType());
                    continue;
                }
                if (edge.hasTargetLabel()) {
                    targetMerge.label(edge.getTargetLabel());
                }
                if (edge.hasTargetProperties() && (propertiesFound = this.applyProperties(json, targetMerge, edge.getTargetProperties(), true)) == 0) {
                    LOG.debug("edge, {}, has no match properties", (Object)edge.getEdgeType());
                    continue;
                }
                JcRelation relation = new JcRelation("r".concat(Integer.toString(count)));
                Relation intermediate = MERGE.node((JcNode)head).relation(relation);
                if (edge.hasEdgeType()) {
                    intermediate.type(edge.getEdgeType());
                }
                Node relationMerge = intermediate.out().node(target);
                clauses.add(targetMerge);
                clauses.add(relationMerge);
                ++count;
            }
        }
        JcQuery query = new JcQuery(PlannerStrategy.DEFAULT);
        query.setClauses(clauses.toArray(new IClause[0]));
        return query;
    }

    public int applyProperties(JsonNode json, Node merge, Map<String, Function<JsonNode, Object>> properties, boolean ignoreNull) {
        int count = 0;
        for (Map.Entry<String, Function<JsonNode, Object>> entry : properties.entrySet()) {
            Object value = entry.getValue().apply(json);
            if (ignoreNull && value == null) continue;
            if (value == null) {
                throw new IllegalStateException("property: " + entry.getKey() + ", many not be null");
            }
            merge.property(entry.getKey()).value(value);
            ++count;
        }
        return count;
    }

    public Map<String, Object> asProperties(JsonNode node) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Map map = (Map)this.objectMapper.convertValue((Object)node, Map.class);
        this.nest(result, null, map);
        return result;
    }

    private void nest(Map<String, Object> result, String prefix, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String nestedKey;
            String currentKey = this.cleanKey(entry.getKey());
            Object value = entry.getValue();
            String string = nestedKey = prefix == null ? currentKey : prefix + "_" + currentKey;
            if (value instanceof Map) {
                this.nest(result, nestedKey, (Map)value);
                continue;
            }
            result.put(nestedKey, value);
        }
    }

    protected String cleanKey(String key) {
        return key.replace(':', '-').replace('-', '_').replace('/', '_').replace('.', '_');
    }
}

