/*
 * Decompiled with CFR 0.152.
 */
package cascading.local.tap.kafka.decorator;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class ForwardingConsumer<K, V>
implements Consumer<K, V> {
    Consumer<K, V> consumer;

    public ForwardingConsumer(Properties properties) {
        this.consumer = this.createKafkaConsumerInstance(properties);
    }

    protected KafkaConsumer<K, V> createKafkaConsumerInstance(Properties properties) {
        return new KafkaConsumer(properties);
    }

    public Consumer<K, V> getConsumer() {
        return this.consumer;
    }

    public Set<TopicPartition> assignment() {
        return this.consumer.assignment();
    }

    public Set<String> subscription() {
        return this.consumer.subscription();
    }

    public void subscribe(Collection<String> collection) {
        this.consumer.subscribe(collection);
    }

    public void subscribe(Collection<String> collection, ConsumerRebalanceListener consumerRebalanceListener) {
        this.consumer.subscribe(collection, consumerRebalanceListener);
    }

    public void assign(Collection<TopicPartition> collection) {
        this.consumer.assign(collection);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener consumerRebalanceListener) {
        this.consumer.subscribe(pattern, consumerRebalanceListener);
    }

    public void subscribe(Pattern pattern) {
        this.consumer.subscribe(pattern);
    }

    public void unsubscribe() {
        this.consumer.unsubscribe();
    }

    @Deprecated
    public ConsumerRecords<K, V> poll(long l) {
        return this.consumer.poll(l);
    }

    public ConsumerRecords<K, V> poll(Duration duration) {
        return this.consumer.poll(duration);
    }

    public void commitSync() {
        this.consumer.commitSync();
    }

    public void commitSync(Duration duration) {
        this.consumer.commitSync(duration);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> map) {
        this.consumer.commitSync(map);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> map, Duration duration) {
        this.consumer.commitSync(map, duration);
    }

    public void commitAsync() {
        this.consumer.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback offsetCommitCallback) {
        this.consumer.commitAsync(offsetCommitCallback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> map, OffsetCommitCallback offsetCommitCallback) {
        this.consumer.commitAsync(map, offsetCommitCallback);
    }

    public void seek(TopicPartition topicPartition, long l) {
        this.consumer.seek(topicPartition, l);
    }

    public void seekToBeginning(Collection<TopicPartition> collection) {
        this.consumer.seekToBeginning(collection);
    }

    public void seekToEnd(Collection<TopicPartition> collection) {
        this.consumer.seekToEnd(collection);
    }

    public long position(TopicPartition topicPartition) {
        return this.consumer.position(topicPartition);
    }

    public long position(TopicPartition topicPartition, Duration duration) {
        return this.consumer.position(topicPartition, duration);
    }

    public OffsetAndMetadata committed(TopicPartition topicPartition) {
        return this.consumer.committed(topicPartition);
    }

    public OffsetAndMetadata committed(TopicPartition topicPartition, Duration duration) {
        return this.consumer.committed(topicPartition, duration);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.consumer.metrics();
    }

    public List<PartitionInfo> partitionsFor(String string) {
        return this.consumer.partitionsFor(string);
    }

    public List<PartitionInfo> partitionsFor(String string, Duration duration) {
        return this.consumer.partitionsFor(string, duration);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.consumer.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration duration) {
        return this.consumer.listTopics(duration);
    }

    public Set<TopicPartition> paused() {
        return this.consumer.paused();
    }

    public void pause(Collection<TopicPartition> collection) {
        this.consumer.pause(collection);
    }

    public void resume(Collection<TopicPartition> collection) {
        this.consumer.resume(collection);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> map) {
        return this.consumer.offsetsForTimes(map);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> map, Duration duration) {
        return this.consumer.offsetsForTimes(map, duration);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> collection) {
        return this.consumer.beginningOffsets(collection);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> collection, Duration duration) {
        return this.consumer.beginningOffsets(collection, duration);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> collection) {
        return this.consumer.endOffsets(collection);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> collection, Duration duration) {
        return this.consumer.endOffsets(collection, duration);
    }

    public void close() {
        this.consumer.close();
    }

    @Deprecated
    public void close(long l, TimeUnit timeUnit) {
        this.consumer.close(l, timeUnit);
    }

    public void close(Duration duration) {
        this.consumer.close(duration);
    }

    public void wakeup() {
        this.consumer.wakeup();
    }
}

