/*
 * Decompiled with CFR 0.152.
 */
package cascading.aws.s3.logs;

import cascading.aws.s3.logs.CleanCoercibleType;
import cascading.tuple.Fields;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.DateType;
import java.lang.reflect.Type;
import java.util.TimeZone;

public class S3Logs {
    public static final String REGEX = "(\\S+) ([a-z0-9][a-z0-9-.]+) \\[(.*\\+.*)] (\\b(?:\\d{1,3}\\.){3}\\d{1,3}\\b) (\\S+) (\\S+) (\\S+) (\\S+) \"(\\w+ \\S+ \\S+)\" (\\d+|-) (\\S+) (\\d+|-) (\\d+|-) (\\d+|-) (\\d+|-) \"(https?://.*/?|-)\" \"(.*)\" (\\S+)";
    public static final CleanCoercibleType<Long> CLEAN_LONG = new CleanCoercibleType(Coercions.LONG_OBJECT, o -> o.equals("-") ? null : o);
    public static final CleanCoercibleType<String> CLEAN_STRING = new CleanCoercibleType(Coercions.STRING, o -> o.equals("-") ? null : o);
    public static Fields BUCKET_OWNER = new Fields((Comparable)((Object)"bucketOwner"), String.class);
    public static Fields BUCKET = new Fields((Comparable)((Object)"bucket"), String.class);
    public static Fields TIME = new Fields((Comparable)((Object)"time"), (Type)new DateType("dd/MMM/yyyy:HH:mm:ss Z", TimeZone.getTimeZone("UTC")));
    public static Fields REMOTE_IP_ADDRESS = new Fields((Comparable)((Object)"remoteIpAddress"), String.class);
    public static Fields REQUESTER = new Fields((Comparable)((Object)"requester"), CLEAN_STRING);
    public static Fields REQUEST_ID = new Fields((Comparable)((Object)"requestId"), String.class);
    public static Fields OPERATION = new Fields((Comparable)((Object)"operation"), String.class);
    public static Fields KEY = new Fields((Comparable)((Object)"key"), CLEAN_STRING);
    public static Fields REQUEST_URI = new Fields((Comparable)((Object)"requestUri"), String.class);
    public static Fields HTTP_STATUS = new Fields((Comparable)((Object)"httpStatus"), Integer.class);
    public static Fields ERROR_CODE = new Fields((Comparable)((Object)"errorCode"), CLEAN_STRING);
    public static Fields BYTES_SENT = new Fields((Comparable)((Object)"bytesSent"), CLEAN_LONG);
    public static Fields OBJECT_SIZE = new Fields((Comparable)((Object)"objectSize"), CLEAN_LONG);
    public static Fields TOTAL_TIME = new Fields((Comparable)((Object)"totalTime"), CLEAN_LONG);
    public static Fields TURN_AROUND_TIME = new Fields((Comparable)((Object)"turnAroundTime"), CLEAN_LONG);
    public static Fields REFERRER = new Fields((Comparable)((Object)"referrer"), CLEAN_STRING);
    public static Fields USER_AGENT = new Fields((Comparable)((Object)"userAgent"), String.class);
    public static Fields VERSION_ID = new Fields((Comparable)((Object)"versionId"), CLEAN_STRING);
    public static final Fields FIELDS = Fields.NONE.append(BUCKET_OWNER).append(BUCKET).append(TIME).append(REMOTE_IP_ADDRESS).append(REQUESTER).append(REQUEST_ID).append(OPERATION).append(KEY).append(REQUEST_URI).append(HTTP_STATUS).append(ERROR_CODE).append(BYTES_SENT).append(OBJECT_SIZE).append(TOTAL_TIME).append(TURN_AROUND_TIME).append(REFERRER).append(USER_AGENT).append(VERSION_ID);
}

