package carpool.delvelogic.library.utils.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

import carpool.delvelogic.library.models.UserModel;
import carpool.delvelogic.library.utils.Constants;

public class UserPreferences {

	public static void setUserData(Context context,UserModel model){
		byte[] data = HelperMethods.serialize(model);
		SharedPreferences preferences = context.getSharedPreferences(Constants.SHARED_PREF, Context.MODE_PRIVATE);
		Editor editor = preferences.edit();
		editor.putString(Constants.SHARED_PREF, HelperMethods.encode(data));
		if(!editor.commit())
			editor.apply();
	}
	
	// Use this method to fetch all data of the user
	public static UserModel getUserData(Context context){
		SharedPreferences preferences = context.getSharedPreferences(Constants.SHARED_PREF, Context.MODE_PRIVATE);
		String data = preferences.getString(Constants.SHARED_PREF, null);
		UserModel model = (data != null) ? getModelDeserialized(data): new UserModel();
		return model;
	}

	public static UserModel getModelDeserialized(String data){
		UserModel userModel = new UserModel();
		try {
			userModel = (UserModel) HelperMethods.deserialize(HelperMethods.decode(data));
			userModel = userModel == null ? new UserModel() : userModel;
		}catch (Exception e){
			e.printStackTrace();
			userModel = new UserModel();
		}
		return userModel;
	}
	
	public static String getUserName(Context context){
		UserModel model = getUserData(context);
		if(model != null)
			return model.getUserName();
		return null;
	}

}
