package carpool.delvelogic.library.utils.preferences;

import android.content.Context;
import android.content.SharedPreferences;

import carpool.delvelogic.library.utils.Constants;

/**
 * Created by abhishek on 09/03/16.
 */
public class PrefUtil {

    Context context;
    SharedPreferences preferences;
    SharedPreferences.Editor prefEdit;

    static String KEY_ACCESS_TOKEN = "PrefAccessToken";

    public PrefUtil(Context ctx) {
        this.context = ctx;
        this.preferences = context.getSharedPreferences(Constants.SHARED_PREF, Context.MODE_PRIVATE);
        this.prefEdit = preferences.edit();
    }

    void saveChanges(){
        if(!prefEdit.commit())
            prefEdit.apply();
    }

    String getString(String key){
        return preferences.getString(key, "");
    }

    void saveString(String key, String value){
        if(value == null)
            value = "";
        prefEdit.putString(key, value);
        saveChanges();
    }

    public void saveAccesstoken(String value){
        saveString(KEY_ACCESS_TOKEN, value);
    }

    public String getAccessToken(){
        return getString(KEY_ACCESS_TOKEN);
    }
}
