package carpool.delvelogic.library.network;

import android.content.Context;
import android.os.AsyncTask;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import carpool.delvelogic.library.network.customVolley.JsonObjectRequest;
import com.android.volley.toolbox.Volley;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import carpool.delvelogic.library.models.ModelInterface;
import carpool.delvelogic.library.network.customVolley.JsonArrayRequest;
import carpool.delvelogic.library.network.networkInterface.RestifyGenericCallback;
import carpool.delvelogic.library.network.networkInterface.RestifyQueryCallback;
import carpool.delvelogic.library.utils.CommonMethods;

/**
 * Created by abhishek on 11/12/15.
 */
public class Restify<T extends ModelInterface> {

    private Context context;
    private String url;
    private RestifyQueryCallback restifyLambdaCallback;
    private RestifyGenericCallback restifyGenericCallback;
    private Class<T> classObj;
    CustomHeaders header;

    public Restify(Context ctx, String url, Class<T> obj) {
        this.context = ctx;
        this.url = url;
        this.classObj = obj;
        HttpsTrustManager.allowAllSSL();
        header = new CustomHeaders(context);
    }

    public void delete(Boolean bool, RestifyGenericCallback restifyGenericCallback) {
        this.restifyGenericCallback = restifyGenericCallback;
        if(CommonMethods.isNetworkAvailable(context))
        {

        }
        else
        {

        }
    }

    public void put(Boolean bool, JSONObject obj, RestifyGenericCallback restifyGenericCallback) {
        this.restifyGenericCallback = restifyGenericCallback;
        if(CommonMethods.isNetworkAvailable(context))
        {

        }
        else
        {

        }
    }

    public void post(Boolean bool, JSONObject obj, RestifyGenericCallback restifyGenericCallback) {
        this.restifyGenericCallback = restifyGenericCallback;
        if(CommonMethods.isNetworkAvailable(context))
        {

        }
        else
        {

        }
    }

    public void get(Boolean bool, RestifyGenericCallback restifyGenericCallback) {
        this.restifyGenericCallback = restifyGenericCallback;
        if(CommonMethods.isNetworkAvailable(context))
        {
            JsonObjectRequest request = new JsonObjectRequest(Request.Method.GET, url,"", new Response.Listener<JSONObject>(){
                @Override
                public void onResponse(JSONObject response) {
                    MyGenericAsyncTask myGenericAsyncTask = new MyGenericAsyncTask(response);
                    myGenericAsyncTask.execute();
                }
            }, new Response.ErrorListener(){
                @Override
                public void onErrorResponse(VolleyError error) {
                    CommonMethods.showError(context, error.getLocalizedMessage());
                }
            }, header.getHeaders());

            /*JsonObjectRequest request = new JsonObjectRequest(Request.Method.GET, url, new Response.Listener<JSONObject>() {
                @Override
                public void onResponse(JSONObject response) {
                    MyGenericAsyncTask myGenericAsyncTask = new MyGenericAsyncTask(response);
                    myGenericAsyncTask.execute();
                }
            }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    CommonMethods.showError(context, error.getLocalizedMessage());
                }
            });*/
            Volley.newRequestQueue(context).add(request);
        }
        else
            CommonMethods.showNetworkError(context);
    }

    public void query(Boolean bool,RestifyQueryCallback restifyLambdaCallback) {
        this.restifyLambdaCallback = restifyLambdaCallback;
        if(CommonMethods.isNetworkAvailable(context))
        {

            JsonArrayRequest request = new JsonArrayRequest(Request.Method.GET, url, "", new Response.Listener<JSONArray>() {
                @Override
                public void onResponse(JSONArray response) {
                    MyQueryAsyncTask myQueryAsyncTask = new MyQueryAsyncTask(response);
                    myQueryAsyncTask.execute();
                }
            }, new Response.ErrorListener(){
                @Override
                public void onErrorResponse(VolleyError error) {
                    CommonMethods.showError(context, error.getLocalizedMessage());
                }
            }, header.getHeaders());
            /*JsonArrayRequest request = new JsonArrayRequest(Request.Method.GET, url, new Response.Listener<JSONArray>() {
                @Override
                public void onResponse(JSONArray response) {
                    MyQueryAsyncTask myQueryAsyncTask = new MyQueryAsyncTask(response);
                    myQueryAsyncTask.execute();
                }
            }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    CommonMethods.showError(context, error.getLocalizedMessage());
                }
            });*/
            Volley.newRequestQueue(context).add(request);
        }
        else
            CommonMethods.showNetworkError(context);
    }


    public class MyQueryAsyncTask extends AsyncTask<Void, Void, Void> {

        JSONArray jsonArray;
        ArrayList<T> list = new ArrayList<>();

        public MyQueryAsyncTask(JSONArray arr) {
            this.jsonArray = arr;
        }

        @Override
        protected Void doInBackground(Void... voids) {
            try {
                for (int i = 0; i < jsonArray.length(); i++) {
                    try {
                        T t = classObj.newInstance();
                        t.fromJson(jsonArray.optJSONObject(i));
                        if (t != null)
                            list.add(t);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);
            sendCallback(null, list);
        }
    }

    public class MyGenericAsyncTask extends AsyncTask<Void, Void, Void> {

        JSONObject jsonObject, errorObj;
        T t;

        public MyGenericAsyncTask(JSONObject obj) {
            this.jsonObject = obj;
        }

        @Override
        protected Void doInBackground(Void... voids) {
            try {
                errorObj = jsonObject.optJSONObject("error");

                if(errorObj == null) {
                    t = classObj.newInstance();
                    t.fromJson(jsonObject);
                }else
                    t = null;

            } catch (Exception e) {
                e.printStackTrace();
                t = null;
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void aVoid) {
            super.onPostExecute(aVoid);

            sendCallback(errorObj, t);
        }

    }

    public void sendCallback(JSONObject errorObj, T t) {
        try {
            if (errorObj == null && t == null) {
//                CommonMethods.showToast(context, context.getString(R.string.some_error_occurred));
            }
            else
                restifyGenericCallback.callback(errorObj, t);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void sendCallback(JSONObject errorObj, ArrayList<T> t) {
        try {
            if (errorObj == null && t == null) {
//                CommonMethods.showToast(context, context.getString(R.string.some_error_occurred));
            }
            else
                restifyLambdaCallback.callback(errorObj, t);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

}
