package carpool.delvelogic.library.network;

import android.content.Context;

import java.util.HashMap;

import carpool.delvelogic.library.utils.Constants;
import carpool.delvelogic.library.utils.preferences.PrefUtil;

/**
 * Created by abhishek on 09/03/16.
 */
public class CustomHeaders {
    Context ctx;
    PrefUtil prefUtil;

    public CustomHeaders(Context context) {
        this.ctx = context;
        this.prefUtil = new PrefUtil(context);
    }

    public HashMap<String, String> getHeaders(){
        HashMap<String, String> headers = new HashMap<>();
        headers.put(Constants.HEADER_KEY_CLIENT_ID, Constants.HEADER_VALUE_CLIENT_ID);
        headers.put(Constants.HEADER_KEY_CLIENT_SECRET, Constants.HEADER_VALUE_CLIENT_SECRET);

        try{
            String accessToken = prefUtil.getAccessToken();
            if(accessToken.trim().length()>0)
                headers.put(Constants.HEADER_KEY_ACCESS_TOKEN_KEY, accessToken);

        }catch (Exception e){
            e.printStackTrace();
        }

        return headers;
    }

}
