package carpool.delvelogic.library.models;

import org.json.JSONObject;

import java.io.Serializable;

public class Device implements Serializable, ModelInterface{
	
	public int OS = 0;
	public String device_id = "", device_name = "";
    public static String KEY_OS = "OS";
    public static String KEY_DEVICE_NAME = "device_name";
    public static String KEY_DEVICE_ID = "device_id";

	public Device(int oS, String device_id, String device_name) {
		super();
		OS = oS;
		this.device_id = device_id;
		this.device_name = device_name;
	}


    public String getDevice_id() {
        return device_id;
    }

    public void setDevice_id(String device_id) {
        this.device_id = device_id;
    }

    public String getDevice_name() {
        return device_name;
    }

    public void setDevice_name(String device_name) {
        this.device_name = device_name;
    }

    public int getOS() {
        return OS;
    }

    public void setOS(int OS) {
        this.OS = OS;
    }

    @Override
    public JSONObject toJson() {
        JSONObject obj = new JSONObject();
        try{
            obj.put(KEY_OS, getOS());
            obj.put(KEY_DEVICE_ID, getDevice_id());
            obj.put(KEY_DEVICE_NAME, getDevice_name());
        }catch (Exception e){
            e.printStackTrace();
        }
        return obj;
    }

    @Override
    public ModelInterface fromJson(JSONObject obj) {
        try{
            setOS(obj.optInt(KEY_OS));
            setDevice_name(obj.optString(KEY_DEVICE_NAME));
            setDevice_id(obj.optString(KEY_DEVICE_ID));
        }catch (Exception e){
            e.printStackTrace();
        }
        return this;
    }
}


