package carpool.delvelogic.library.utils;

import android.content.Context;
import android.location.Location;
import android.widget.Toast;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.text.ParseException;

import carpool.delvelogic.library.models.UserModel;
import carpool.delvelogic.library.network.NetworkStatus;

/**
 * Created by abhishek on 23/02/16.
 */
public class CommonMethods {

    private static Location loc;

    public static boolean isNetworkAvailable(Context ctx) {
        return NetworkStatus.getInstance().isConnected(ctx);
    }

    public static void showNetworkError(Context ctx) {
        showError(ctx, "Network Error");
    }

    public static void showError(Context ctx, String error) {
        Toast.makeText(ctx, error, Toast.LENGTH_SHORT).show();
    }

    public static boolean isValidString(String str) {

        try {
            if (str == null)
                return false;

            if (str.equalsIgnoreCase("null"))
                return false;

            if (str.trim().length() == 0)
                return false;

        } catch (Exception e) {
            return false;
        }
        return true;
    }

    public static long getDateInUnixTimestamp(String date) {
        Date fDate = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(
                "yyyy-MM-dd'T'HH:mm:ss.sss'Z'");
        try {
            fDate = simpleDateFormat.parse(date);
        } catch (ParseException e) {
            e.printStackTrace();
        } catch (org.apache.http.ParseException e) {
            e.printStackTrace();
        }

        return fDate.getTime() / 1000;
    }

    public static long getDefaultTimestampForOlderCarpools() {
        return 1388534400; // 1/1/2014 00:00:00
    }

    public static String getDate(String date) {
        Date fDate = null;
        Date currentDate = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(
                "yyyy-MM-dd'T'HH:mm:ss.sss'Z'");
        SimpleDateFormat currentTime = new SimpleDateFormat(
                "yyyy-MM-dd'T'HH:mm:ss.sss'Z'", Locale.US);
        currentTime.setTimeZone(TimeZone.getTimeZone("UTC"));
        String currentDateandTime = currentTime.format(new Date());
        try {
            currentDate = simpleDateFormat.parse(currentDateandTime);
            fDate = simpleDateFormat.parse(date);
        } catch (Exception e) {
            e.printStackTrace();
            if (date != null)
                fDate = new Date(Long.valueOf(date)); // In some api timestamp is in long format
        }
        String result = "";
        if (fDate != null)
            result = getTimeDifference(fDate, currentDate);
        //		String result = getTimeAgo1(date);
        return result;

    }

    public static String getTimeDifference(Date date1, Date date2) {

        // TODO Auto-generated method stub
        int days, hours, mins, secs;
        int weeks = 0;
        int months = 0;
        int years = 0;
        String dateDifferenceString;
        long difference = date2.getTime() - date1.getTime();
        days = (int) (difference / (1000 * 60 * 60 * 24));
        hours = (int) ((difference / (1000 * 60 * 60)) % 24);// (int)
        mins = (int) (difference / (1000 * 60)) % 60;// (int) (difference -
        long seconds = (difference / 1000) % 60;

        if (days > 365)
            years = days / 365;
        else if (days > 30)
            months = days / 30;
        else if (days > 7)
            weeks = days / 7;


        if (years > 0) {
            if (years == 1)
                dateDifferenceString = "" + years + " Year Ago";
            else
                dateDifferenceString = "" + years + " Years Ago";
        } else {

            if (months > 0)
                if (months == 1)
                    dateDifferenceString = "" + months + " Month Ago";
                else
                    dateDifferenceString = "" + months + " Months Ago";
            else {
                if (weeks > 0) {
                    if (weeks == 1)
                        dateDifferenceString = "" + weeks + " Week Ago";
                    else
                        dateDifferenceString = "" + weeks + " Weeks Ago";
                } else {
                    if (days == 1)
                        dateDifferenceString = "" + days + " Day Ago";
                    else
                        dateDifferenceString = "" + days + " Days Ago";
                    if (days <= 0) {
                        if (hours == 1)
                            dateDifferenceString = "" + hours + " Hour Ago";
                        else
                            dateDifferenceString = "" + hours + " Hours Ago";
                        if (hours <= 0) {
                            dateDifferenceString = "" + mins + " Mins Ago";
                            if (mins <= 0) {

                                if (seconds < 0)
                                    seconds = (-seconds);
                                dateDifferenceString = "" + seconds + " Seconds Ago";

                            }
                        }
                    }
                }
            }
        }

        return dateDifferenceString;
    }

    public static String getLeavingInText(String time) {
        String text;
        try {
            time = time.replace("Hrs", "");
            time = time.trim();
            int startTimeHour = Integer.parseInt(time.split(":")[0]);
            int startTimeMin = Integer.parseInt(time.split(":")[1]);
            text = "";
            Calendar mcurrentTime = Calendar.getInstance();
            int hour = mcurrentTime.get(Calendar.HOUR_OF_DAY);
            int minute = mcurrentTime.get(Calendar.MINUTE);
            int hourDifference = hour - startTimeHour;
            int minuteDifference = minute - startTimeMin;
            if (hourDifference < 0)
                text = "Leaving in " + (-hourDifference) + " Hours";
            else if (hourDifference == 0)
                if (minuteDifference < 1)
                    text = "Leaving in " + (-minuteDifference) + " Minutes";
                else if (minuteDifference <= 1 && minuteDifference >= -5)
                    text = "Carpool Just Started";
                else
                    text = "Left " + (minuteDifference) + " Minutes back";
            else
                text = "Will Leave Tomorrow";
        } catch (NumberFormatException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            text = "Contact for Timing";
        } catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            text = "Contact for Timing";
        }
        return text;
    }

    public static boolean isUserModelValid(UserModel userModel) {

        try {
            if (userModel == null)
                return false;

            if(!isValidString(userModel.get_id()))
                return false;

            if (userModel.getUserName() == null)
                return false;

            if (userModel.getUserName().trim().length() == 0)
                return false;

        } catch (Exception e) {
            e.printStackTrace();
        }

        return true;

    }

    public static Location getLoc() {
        return loc;
    }

    public static void setLoc(Location loc) {
        CommonMethods.loc = loc;
    }

    public static boolean isTripValid(long lastLocUpdated) {

        long timestamp = System.currentTimeMillis() / 1000;
        long difference = timestamp - lastLocUpdated;

        difference = difference / (60 * 60);
        if (difference > 1)
            return false;
        return true;
    }


    // If the location
    public static boolean isTripValidForRealtimeNotification(long lastLocUpdated) {

        long timestamp = System.currentTimeMillis() / 1000;
        long difference = timestamp - lastLocUpdated;

        difference = difference / (60);
        if (difference > 30)
            return false;
        return true;
    }


    public static boolean isLocValid(Location loc){

        try{
            if(loc != null && loc.getLatitude() != 0d && loc.getLongitude() != 0d)
                return true;
        }catch (Exception e){
            e.printStackTrace();
        }

        return false;
    }
}
