package carpool.delvelogic.library.models;

import org.json.JSONObject;

import java.io.Serializable;

public class Profile implements Serializable, ModelInterface {
	String type = "", url = "", profile_id = "" , _id = "";

    public static String KEY_ID = "_id";
    public static String KEY_PROFILE_ID = "id";
    public static String KEY_TYPE = "type";
    public static String KEY_URL = "url";

    public Profile() {
    }

    public Profile(JSONObject obj) {
		try{
            setProfileModelFromJson(obj);
        }catch (Exception e){
            e.printStackTrace();
        }
	}

    private void setProfileModelFromJson(JSONObject obj) {
        url = obj.optString(KEY_URL);
        type = obj.optString(KEY_TYPE);
        profile_id = obj.optString(KEY_PROFILE_ID);
        _id = obj.optString(KEY_ID);
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getProfile_id() {
        return profile_id;
    }

    public void setProfile_id(String profile_id) {
        this.profile_id = profile_id;
    }

    public String get_id() {
        return _id;
    }

    public void set_id(String _id) {
        this._id = _id;
    }

    @Override
    public JSONObject toJson() {
        JSONObject obj = new JSONObject();
        try{
            obj.put(KEY_URL, getUrl());
            obj.put(KEY_TYPE, getType());
            obj.put(KEY_PROFILE_ID, getProfile_id());
            obj.put(KEY_ID, get_id());
        }catch (Exception e){
            e.printStackTrace();
        }
        return obj;
    }

    @Override
    public ModelInterface fromJson(JSONObject obj) {
        setProfileModelFromJson(obj);
        return this;
    }
}
