package carpool.delvelogic.library.models;

import android.location.Location;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import carpool.delvelogic.library.utils.CommonMethods;

/**
 * Created by abhishek on 22/12/15.
 */
public class MasterCarpool implements Serializable, ModelInterface{

    ArrayList<CarPool> carPools, realtimeCarpools;
    public static String KEY_CARPOOLS = "carpools";
    public static String KEY_GEOLOCS = "geoLocs";
    public ArrayList<CarPool> getCarPools() {
        return carPools;
    }

    public void setCarPools(ArrayList<CarPool> carPools) {
        this.carPools = carPools;
    }

    public ArrayList<CarPool> getRealtimeCarpools() {
        return realtimeCarpools;
    }

    public void setRealtimeCarpools(ArrayList<CarPool> realtimeCarpools) {
        this.realtimeCarpools = realtimeCarpools;
    }

    @Override
    public JSONObject toJson() {
        JSONObject obj = new JSONObject();
        try{
            JSONArray carpoolArr = new JSONArray();
            for(int i=0; i<carPools.size(); i++)
                carpoolArr.put(carPools.get(i).toJson());

            JSONArray realtimeArr = new JSONArray();
            for(int i=0; i<realtimeCarpools.size(); i++)
                realtimeArr.put(realtimeCarpools.get(i).toJson());

            obj.put(KEY_CARPOOLS, carpoolArr);
            obj.put(KEY_GEOLOCS, realtimeCarpools);
        }catch (Exception e){
            e.printStackTrace();
        }
        return obj;
    }

    @Override
    public ModelInterface fromJson(JSONObject obj) {
        JSONArray carpools = obj.optJSONArray(KEY_CARPOOLS);
        JSONArray geolocs = obj.optJSONArray(KEY_GEOLOCS);
        carPools = new ArrayList<>();
        realtimeCarpools = new ArrayList<>();
        if (carpools != null && carpools.length() > 0)
            parseCarpools(carpools);
        if (geolocs != null && geolocs.length() > 0)
            parseRealtime(geolocs);
        return null;
    }

    void parseCarpools(JSONArray carpools){
        try {
            if (carpools.length() > 0) {
                for (int i = 0; i < carpools.length(); i++) {
                    try {
                        JSONObject json = carpools.getJSONObject(i);
                        CarPool carpool = new CarPool(json.toString(), false);
                        if (CommonMethods.isUserModelValid(carpool.getUser()))
                            carPools.add(carpool);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sortFutureCarpools(carPools);
            }

        }catch (Exception e){
            e.printStackTrace();
        }
    }

    void parseRealtime(JSONArray realtimeArr){
        try{
            for (int i = 0; i < realtimeArr.length(); i++) {
                try {
                    JSONObject obj = realtimeArr.optJSONObject(i);
                    CarPool carpool = new CarPool(obj.toString(), true);

                    if (CommonMethods.isTripValid(carpool.lastLocationUpdatedTime) && CommonMethods.isUserModelValid(carpool.getUser())) {
                        carpool = setDistanceBetweenUserAndCarpoolLocation(carpool);
                        realtimeCarpools.add(carpool);
                    }
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
            sortRealtimeCarpoolList(realtimeCarpools);

        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private CarPool setDistanceBetweenUserAndCarpoolLocation(CarPool carpool) {
        try {
            Location presentLocation = CommonMethods.getLoc();
            Location carpoolLocation = new Location("CarpoolLocation");
            carpoolLocation.setLatitude(carpool.presentLat);
            carpoolLocation.setLongitude(carpool.presentLon);
            carpool.setDistanceBetweenLocations(presentLocation, carpoolLocation);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return carpool;
    }

    private void sortRealtimeCarpoolList(ArrayList<CarPool> list) {
        try {
            Collections.sort(list, new Comparator<CarPool>() {
                @Override
                public int compare(CarPool lhs, CarPool rhs) {
                    int distance1 = Math.round(lhs.distanceBetweenLocations);
                    int distance2 = Math.round(rhs.distanceBetweenLocations);

                    if (distance1 <= distance2)
                        return -1;
                    else
                        return 1;

                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void sortFutureCarpools(ArrayList<CarPool> list) {
        try {
            if (list.size() > 0) {
                Collections.sort(list, new Comparator<CarPool>() {
                    @Override
                    public int compare(CarPool lhs, CarPool rhs) {
                        if (lhs.carpoolCreatedTimeInUnixTimestamp > rhs.carpoolCreatedTimeInUnixTimestamp)
                            return -1;
                        else
                            return 1;
                    }
                });
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
