package carpool.delvelogic.library.models;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * Created by abhishek on 17/02/16.
 */
public class Geoloc {

    String _id = "", toName = "", fromName = "", status = "";
    UserModel user;
    double fromLat = 0, fromLon = 0, toLat = 0, toLon = 0;
    long timestamp = 0;

    public Geoloc(JSONObject obj) {
        try{
            _id = obj.optString("_id");
            toName = obj.optString("toName");
            fromName = obj.optString("fromName");
            status = obj.optString("status");

            JSONObject userObj = obj.optJSONObject("user");
            user = new UserModel(userObj);

            JSONObject locObj = obj.optJSONObject("loc");
            JSONArray coordinatesArr = locObj.optJSONArray("coordinates");
            fromLat = coordinatesArr.optDouble(1);
            fromLon = coordinatesArr.optDouble(0);

            JSONObject toLocObj = obj.optJSONObject("toLoc");
            JSONArray toCoordinatesArr = toLocObj.optJSONArray("coordinates");
            toLat = toCoordinatesArr.optDouble(1);
            toLon = toCoordinatesArr.optDouble(0);
            timestamp = obj.optLong("timestamp");

        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public String get_id() {
        return _id;
    }

    public String getToName() {
        return toName;
    }

    public String getFromName() {
        return fromName;
    }

    public String getStatus() {
        return status;
    }

    public UserModel getUser() {
        return user;
    }

    public double getFromLat() {
        return fromLat;
    }

    public double getFromLon() {
        return fromLon;
    }

    public double getToLat() {
        return toLat;
    }

    public double getToLon() {
        return toLon;
    }

    public long getTimestamp() {
        return timestamp;
    }
}
