package carpool.delvelogic.library.models;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;

@SuppressWarnings("serial")
public class UserModel implements Serializable, ModelInterface{

	String userName="", _id="", age="", contact="", email="", companyId = "",
			fbid="", /*fbUrl="",*/ image="", points="", regid="", sex="", fbToken="";
	int uid=0;
	Device deviceModel;
    ArrayList<Profile> profileList;
//    ArrayList<UserBlocked> usersListBlockedByMe, usersListNotAllowed;
    ArrayList<CarPool> interestedCarpools = new ArrayList<>();
    ArrayList<String> blockedUsers = new ArrayList<>();
    int blockedBy = 0;

	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String get_id() {
		return _id;
	}
	public void set_id(String _id) {
		this._id = _id;
	}
	public String getAge() {
		return age;
	}
	public void setAge(String age) {
		this.age = age;
	}
	public String getContact() {
		return contact;
	}
	public void setContact(String contact) {
		this.contact = contact;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}

	public String getImage() {
		return image;
	}
	public void setImage(String image) {
		this.image = image;
	}
	
	public String getPoints() {
		return points;
	}
	public void setPoints(String points) {
		this.points = points;
	}
	public String getRegid() {
		return regid;
	}
	public void setRegid(String regid) {
		this.regid = regid;
	}
	public String getSex() {
		return sex;
	}
	public void setSex(String sex) {
		this.sex = sex;
	}
	public int getUid() {
		return uid;
	}
	public void setUid(int uid) {
		this.uid = uid;
	}
	public String getFbToken() {
		return fbToken;
	}
	public void setFbToken(String fbToken) {
		this.fbToken = fbToken;
	}

    public ArrayList<Profile> getProfileList() {
        return profileList;
    }

    public void setProfileList(ArrayList<Profile> profileList) {
        this.profileList = profileList;
    }


    public void setDeviceModel(Device device){
        this.deviceModel = device;
    }

    AccessToken fbAccessToken;

    public Device getDeviceModel(){
        return deviceModel;
    }

    public UserModel(){

    }

    public UserModel(JSONObject obj){
        setUserModelFromJson(obj);
    }

    private void setUserModelFromJson(JSONObject obj) {
        try{
            set_id(obj.optString("_id"));
            setAge(obj.optString("age"));
            setContact(obj.optString("contact"));

            JSONObject deviceObj = obj.optJSONObject("device");
            int OS = deviceObj.optInt("OS");
            String deviceId = deviceObj.optString("device_id");
            String deviceName = deviceObj.optString("device_name");
            Device device = new Device(OS, deviceId, deviceName);
            setDeviceModel(device);

            setEmail(obj.optString("email"));
            setImage(obj.optString("image"));
            setFbid(obj.optString("fbid"));
            setRegid(obj.optString("regid"));
            setUserName(obj.optString("name"));
            setPoints("" + obj.optInt("points"));

            setSex(obj.optString("sex"));
            setUid(obj.optInt("uid"));

            try{
                String companyId = fetchCompanyFromCompanyObject(obj).length() == 0 ? fetchCompanyId(obj) : fetchCompanyFromCompanyObject(obj);
                setCompanyId(companyId);
            }catch (Exception e){
                e.printStackTrace();
            }

            this.profileList = new ArrayList<Profile>();

            try{
                JSONArray arr = obj.optJSONArray("profiles");
                for(int i=0; i<arr.length(); i++){
                    JSONObject profileObj = arr.optJSONObject(i);
                    Profile profile = new Profile(profileObj);
                    profileList.add(profile);
                }

            }catch (Exception e){
                e.printStackTrace();
            }

            setBlockedUsers(obj);
            blockedBy = obj.optInt("blockedBy");

        }catch (Exception e){
            e.printStackTrace();
        }
    }

    private void setBlockedUsers(JSONObject obj) {
        try {
            if(this.blockedUsers == null)
                this.blockedUsers = new ArrayList<>();
            JSONArray blockedUsersArray = obj.optJSONArray("blocked") == null ? new JSONArray() : obj.optJSONArray("blocked");
            for (int i = 0; i < blockedUsersArray.length(); i++)
                this.blockedUsers.add(blockedUsersArray.optString(i));
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void setBlockedUserList(ArrayList<String> list){
        this.blockedUsers = list;
    }

    private String fetchCompanyFromCompanyObject(JSONObject obj) {
        JSONObject companyObj = obj.optJSONObject("company");
        return companyObj == null ? "" : companyObj.optString("_id");
    }

    private String fetchCompanyId (JSONObject obj){
        String companyId = obj.optString("company");
        return companyId == null || companyId.equalsIgnoreCase("null") ? "" : companyId;
    }

    public String getFbid() {
        return fbid;
    }

    public void setFbid(String fbid) {
        this.fbid = fbid;
    }

    public AccessToken getFbAccessToken() {
        return fbAccessToken;
    }

    public void setFbAccessToken(AccessToken fbAccessToken) {
        this.fbAccessToken = fbAccessToken;
    }

    public ArrayList<CarPool> getInterestedCarpools() {
        if(interestedCarpools!=null)
            return interestedCarpools;
        return new ArrayList<CarPool>();
    }

    public void setInterestedCarpools(ArrayList<CarPool> interestedCarpools) {
        this.interestedCarpools = interestedCarpools;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        try{
            json.put("_id", this.get_id());
            json.put("name", this.getUserName());
            json.put("image", this.getImage());
            json.put("email", this.getEmail());
            json.put("fbid", this.getFbid());
            json.put("age", this.getAge());
            json.put("sex", this.getSex());
            json.put("regid", this.getRegid());
            json.put("points", this.getPoints());
            json.put("contact", this.getContact());
            json.put("company", this.getCompanyId());

            JSONArray profileArr = new JSONArray();
            for(Profile profile : profileList)
                profileArr.put(profile.toJson());
            json.put("profiles", profileArr);

            json.put("device", getDeviceModel().toJson());
        }catch (Exception e){
            e.printStackTrace();
        }
        return json;
    }

    @Override
    public ModelInterface fromJson(JSONObject obj) {
        setUserModelFromJson(obj);
        return this;
    }

    public ArrayList<String> getBlockedUsers() {
        return this.blockedUsers;
    }

    public void blockUser(String userId){
        if(this.blockedUsers == null)
            this.blockedUsers = new ArrayList<>();

        if(shouldAddBlockedUser(userId))
            this.blockedUsers.add(userId);
    }

    private boolean shouldAddBlockedUser(String userId){
        boolean bool = true;

        try{
            if(userId == null || blockedUsers.contains(userId))
                bool = false;
        }catch (Exception e){
            e.printStackTrace();
        }

        return bool;
    }

    public void unBlockUser(String userId){
        if(this.blockedUsers.contains(userId))
            this.blockedUsers.remove(userId);
    }

    public int getBlockedBy() {
        return blockedBy;
    }

}
