package carpool.delvelogic.library.models;

import android.location.Location;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;

import carpool.delvelogic.library.utils.CommonMethods;

public class CarPool implements Serializable, ModelInterface {

    public String source = "", destination = "", _id = "", carModel = "", chargePrice = "",
            fueltype = "", returnTime = "", smoking = "", startTime = "";
    public String timeAgo = "", carType = "";
    public int views = 0;
    public double fromLat, fromLon, toLat, toLon;
    public long carpoolCreatedTimeInUnixTimestamp;
    //    public int id, uid;
    public String otherText = "", specificDay = "", timeStamp = "", leavingIn = "", companyId = "";
    public Device device;
    public boolean hasCar = true, isRegularCarpool = true;

    public int type = 0; // 0 : normal carpool , 1 : realtime carpool
    public int visibility = 0; // 0 : Everyone, 1 : Only Company, 2: Everyone but company
    public boolean isDriver = false;
    public double presentLon, presentLat, drivingToLat, drivingToLng;
    public String timeAway = "", toName = "";
    public float distanceBetweenLocations;
    private SerialBitmap realtimeBitmap;
    public long lastLocationUpdatedTime, carpoolLastUpdated;
    UserModel user;
    public Location phoneLocation;
    public boolean isRealtime = false, isActualTime = false, isShared = false;

    public CarPool() {
    }

    public CarPool(String resp, boolean isRealtime) {
        super();
        this.isRealtime = isRealtime;
        generateCarpool(resp);
    }

    public boolean isRealtime() {
        return isRealtime;
    }

    public void setIsRealtime(boolean isRealtime) {
        this.isRealtime = isRealtime;
    }

    private void generateCarpool(String resp) {
        if (!isRealtime)
            generateFutureCarpool(resp);
        else
            generateReatimeCarpool(resp);
    }

    private void generateReatimeCarpool(String resp) {
        try {
            JSONObject obj = new JSONObject(resp);
            this._id = obj.optString("_id");
            this.type = 1;
            String status = obj.optString("status");
            isShared = obj.optBoolean("isShared");
            this.isDriver = status.equalsIgnoreCase("isDriving") ? true : false;
            this.lastLocationUpdatedTime = obj.optLong("timestamp");
            //			this.timeAgo = Utils.getDate(obj.optString("timestamp")); // this is coming in long
            JSONObject locObj = obj.optJSONObject("loc");
            JSONArray locArr = locObj.optJSONArray("coordinates");
            presentLon = locArr.optDouble(0);
            presentLat = locArr.optDouble(1);

            if (isDriver) {
                JSONObject toLocObj = obj.optJSONObject("toLoc");
                JSONArray toLocArr = toLocObj.optJSONArray("coordinates");
                drivingToLat = toLocArr.optDouble(0);
                drivingToLng = toLocArr.optDouble(1);
            }

            JSONObject userObj = obj.optJSONObject("user");
            generateUserObj(userObj);
            toName = obj.optString("toName");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateFutureCarpool(String resp) {
        try {
            JSONObject json = new JSONObject(resp);
            JSONObject loc = json.getJSONObject("loc");
            JSONArray coordinates = loc.getJSONArray("coordinates");
            Double fromLon = coordinates.getJSONArray(1).getDouble(0);
            Double fromLat = coordinates.getJSONArray(1).getDouble(1);

            Double toLon = coordinates.getJSONArray(0).getDouble(0);
            Double toLat = coordinates.getJSONArray(0).getDouble(1);
            JSONObject userObj = json.optJSONObject("user");

            this.source = json.getString("fromName");
            this.destination = json.getString("toName");
            this._id = json.optString("_id");
            this.carModel = json.optString("carModel");
            this.chargePrice = json.optString("chargePrice");
            this.fueltype = json.optString("fuelType");
            this.returnTime = json.optString("returnTime");
            this.visibility = json.optInt("visibility");
            this.carType = json.optString("carType");
            this.carpoolLastUpdated = json.optLong("lastUpdated");

            JSONObject companyObj = json.optJSONObject("company");
            companyId = companyObj == null ? "" : fetchCompanyId(companyObj);

            if (returnTime.contains(" Hrs"))
                returnTime = returnTime.split(" HRs")[0];

            this.smoking = json.optString("smoking");
            this.startTime = json.optString("startTime");

            if (startTime.contains(" Hrs"))
                startTime = startTime.split(" HRs")[0];

            this.fromLat = fromLat;
            this.fromLon = fromLon;
            this.toLat = toLat;
            this.toLon = toLon;

            setTimeAgo(json.optString("timestamp"));
            try {
                this.carpoolCreatedTimeInUnixTimestamp = CommonMethods.getDateInUnixTimestamp(json.optString("timestamp"));
            } catch (Exception e) {
                e.printStackTrace();

                try {
                    String timestamp = json.optString("timestamp");
                    if (CommonMethods.isValidString(timestamp))
                        this.carpoolCreatedTimeInUnixTimestamp = Long.valueOf(timestamp);
                    else
                        this.carpoolCreatedTimeInUnixTimestamp = CommonMethods.getDefaultTimestampForOlderCarpools();

                } catch (Exception ex) {
                    this.carpoolCreatedTimeInUnixTimestamp = CommonMethods.getDefaultTimestampForOlderCarpools();

                }
            }
            this.views = json.optInt("views");

            if (userObj == null) {

                UserModel user = new UserModel();
                user.setUserName(json.getString("name"));
                user.setAge(json.optString("age"));
                user.setSex(json.optString("sex"));
                user.setContact(json.optString("contact"));
                user.setEmail(json.optString("email"));
                user.setRegid(json.optString("regid"));
                ArrayList<Profile> profileList = new ArrayList<Profile>();
                Profile profile = new Profile();
                profile.setType("facebook");
                profile.setProfile_id(json.optString("fbid"));
                profile.setUrl("https://www.facebook.com/profile.php?id=" + json.optString("fbid"));
                profileList.add(profile);
                user.setProfileList(profileList);
                setUser(user);

            } else
                generateUserObj(userObj);

            setTimeStamp(json.optString("timestamp"));
            setHasCar(json.optBoolean("hasCar"));
            setOtherText(json.optString("otherText"));
            setSpecificDay(json.optString("specificDay"));
            setRegularCarpool(json.optBoolean("isRegularCarpool"));

        } catch (JSONException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

    public String fetchCompanyId(JSONObject companyObj) {
        String id = "";

        try{
            id = companyObj.optString("_id");
        }catch (Exception e){
            e.printStackTrace();
        }
        return id;
    }

    public void setDistanceBetweenLocations(Location presentLocation, Location carpoolLocation) {
        distanceBetweenLocations = presentLocation.distanceTo(carpoolLocation);
    }

    private void generateUserObj(JSONObject userObj) throws JSONException {

        UserModel user = new UserModel(userObj);
        user.setRegid(userObj.optString("regid"));
        setUser(user);

    }

    // USed in createCarpoolfragment in searchCallback
    public CarPool(String name, String source, String destination, String _id,
                   String age, String carModel, String chargePrice, String contact,
                   String email, String fbid, String fueltype,
                   String image, int points, String regId, String returnTime,
                   String sex, String smoking, String startTime, double fromLat,
                   double fromLon, double toLat, double toLon, int id, int uid, String timeAgo, int views) {
        super();

        this.source = source;
        this.destination = destination;
        this._id = _id;
        this.carModel = carModel;
        this.chargePrice = chargePrice;
        this.fueltype = fueltype;
        this.returnTime = returnTime;
        this.smoking = smoking;
        this.startTime = startTime;
        this.fromLat = fromLat;
        this.fromLon = fromLon;
        this.toLat = toLat;
        this.toLon = toLon;
//        this.id = id;
//        this.uid = uid;
        this.timeAgo = timeAgo;
        this.views = views;

        UserModel user = new UserModel();
        user.setUserName(name);
        user.setAge(age);
        user.setSex(sex);
        user.setContact(contact);
        user.setRegid(regId);
        user.setEmail(email);

        ArrayList<Profile> profileList = new ArrayList<Profile>();
        Profile profile = new Profile();
        profile.setType("facebook");
        profile.setProfile_id(fbid);
        profile.setUrl("https://www.facebook.com/profile.php?id=" + fbid);
        profileList.add(profile);
        user.setProfileList(profileList);
        setUser(user);

    }



    public String getLeavingIn() {
        return leavingIn;
    }

    public void setLeavingIn(String leavingIn) {
        this.leavingIn = leavingIn;
    }

    public String getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getOtherText() {
        return otherText;
    }

    public void setOtherText(String otherText) {
        this.otherText = otherText;
    }

    public String getSpecificDay() {
        return specificDay;
    }

    public void setSpecificDay(String specificDay) {
        this.specificDay = specificDay;
    }

    public boolean isHasCar() {
        return hasCar;
    }

    public void setHasCar(boolean hasCar) {
        this.hasCar = hasCar;
    }

    public boolean isRegularCarpool() {
        return isRegularCarpool;
    }

    public void setRegularCarpool(boolean isRegularCarpool) {
        this.isRegularCarpool = isRegularCarpool;
    }

    public Device getDevice() {
        return device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getDestination() {
        return destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String get_id() {
        return _id;
    }

    public void set_id(String _id) {
        this._id = _id;
    }

    public String getFueltype() {
        return fueltype;
    }

    public void setFueltype(String fueltype) {
        this.fueltype = fueltype;
    }

    public String getReturnTime() {
        return returnTime;
    }

    public void setReturnTime(String returnTime) {
        this.returnTime = returnTime;
    }

    public String getSmoking() {
        return smoking;
    }

    public void setSmoking(String smoking) {
        this.smoking = smoking;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getTimeAgo() {
        return timeAgo;
    }

    public void setTimeAgo(String timeStamp) {

        String time = "";
        try {

            if (timeStamp == null || timeStamp.length() == 0)
                time = null;
            else
                time = CommonMethods.getDate(timeStamp);
        } catch (Exception e) {
            time = null;
        }
        this.timeAgo = time;
    }


    public int getViews() {
        return views;
    }

    public void setViews(int views) {
        this.views = views;
    }

    public double getFromLat() {
        return fromLat;
    }

    public void setFromLat(double fromLat) {
        this.fromLat = fromLat;
    }

    public double getFromLon() {
        return fromLon;
    }

    public void setFromLon(double fromLon) {
        this.fromLon = fromLon;
    }

    public double getToLat() {
        return toLat;
    }

    public void setToLat(double toLat) {
        this.toLat = toLat;
    }

    public double getToLon() {
        return toLon;
    }

    public void setToLon(double toLon) {
        this.toLon = toLon;
    }

    public SerialBitmap getRealtimeBitmap() {
        return realtimeBitmap;
    }

    public void setRealtimeBitmap(SerialBitmap realtimeBitmap) {
        this.realtimeBitmap = realtimeBitmap;
    }

    public UserModel getUser() {
        return user;
    }

    public void setUser(UserModel user) {
        this.user = user;
    }

    @Override
    public JSONObject toJson() {
        return isRealtime ? getRealtimeJsonObj() : getCarpoolJsonObj();
    }

    public JSONObject getCarpoolJsonObj(){
        JSONObject obj = new JSONObject();
        try{
            obj.put("_id", get_id());
            obj.put("carModel", carModel);
            obj.put("chargePrice", chargePrice);
            obj.put("fromName", getSource());
            obj.put("hasCar", hasCar);
            obj.put("isRegularCarpool", isRegularCarpool());
            obj.put("lastUpdated", carpoolLastUpdated);

            JSONObject locObj = new JSONObject();
            locObj.put("type", "LineString");

            JSONArray locArr = new JSONArray();
            JSONArray fromArr = new JSONArray();
            JSONArray toArr = new JSONArray();
            toArr.put(0, toLon);
            toArr.put(1, toLat);
            fromArr.put(0, fromLon);
            fromArr.put(1, fromLat);
            locArr.put(0, toArr);
            locArr.put(1, fromArr);
            locObj.put("coordinates", locArr);

            obj.put("loc", locObj);
            obj.put("otherText", getOtherText());
            obj.put("returnTime", getReturnTime());
            obj.put("startTime", getStartTime());
            obj.put("toName", getDestination());
            obj.put("timestamp", getTimeStamp());

            JSONObject userObj = getUser().toJson();
            obj.put("user", userObj);
            obj.put("views", views);
            obj.put("visibility", visibility);
        }catch (Exception e){
            e.printStackTrace();
        }
        return obj;
    }

    public JSONObject getRealtimeJsonObj(){
        JSONObject obj = new JSONObject();
        try{
            obj.put("_id", get_id());
            obj.put("isShared", isShared);
            obj.put("status", isDriver ? "isDriving" : "isRiding");
            obj.put("timestamp", lastLocationUpdatedTime);
            obj.put("toName", toName);
            obj.put("user", getUser().toJson());

            JSONObject locObj = new JSONObject();
            locObj.put("type", "Point");
            JSONArray locArr = new JSONArray();
            locArr.put(0, presentLon);
            locArr.put(1, presentLat);
            locObj.put("coordinates", locArr);
            obj.put("loc", locObj);

            JSONObject toLocObj = new JSONObject();
            toLocObj .put("type", "Point");
            JSONArray toLocArr = new JSONArray();
            locArr.put(0, toLon);
            locArr.put(1, toLat);
            locObj.put("coordinates", toLocArr);
            obj.put("toLoc", toLocObj);

        }catch (Exception e){
            e.printStackTrace();
        }

        return obj;
    }

    @Override
    public ModelInterface fromJson(JSONObject obj) {
        try {
            generateCarpool(obj.toString());
            if (CommonMethods.isUserModelValid(getUser()) && get_id() != null)
                return this;
            else
                return null;
        }catch (Exception e){
            return null;
        }
    }
}