package carpool.delvelogic.library.api;

import android.content.Context;
import android.location.Location;

import org.json.JSONObject;

import java.net.URLEncoder;
import java.util.ArrayList;

import carpool.delvelogic.library.R;
import carpool.delvelogic.library.models.CarPool;
import carpool.delvelogic.library.models.MasterCarpool;
import carpool.delvelogic.library.network.Restify;
import carpool.delvelogic.library.network.networkInterface.RestifyGenericCallback;
import carpool.delvelogic.library.utils.CommonMethods;
import carpool.delvelogic.library.utils.Constants;

/**
 * Created by abhishek on 23/02/16.
 */
public class CarpoolRequest {



    public static void fetchLatestCarpools(){

    }

    public static void fetchNearbyCarpools(Context ctx, Location loc, final CarpoolInterface carpoolInterface){

        if(CommonMethods.isLocValid(loc)) {
            String route = Constants.getBaseUrl() + String.format(ctx.getString(R.string.aggregate_api_v3), "", loc.getLatitude(), loc.getLongitude(), "true", "false");
            Restify<MasterCarpool> restify = new Restify<>(ctx, route, MasterCarpool.class);
            restify.get(false, new RestifyGenericCallback() {
                @Override
                public void callback(JSONObject error, Object model) {
                    try {

                        if (error == null) {
                            MasterCarpool masterCarpool = (MasterCarpool) model;
                            carpoolInterface.onSuccess(masterCarpool.getCarPools());
                        } else
                            carpoolInterface.onError(error);

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }else
            carpoolInterface.onLocationError();

    }

    public static void fetchCarpoolsOnRoute(Context ctx, Location fromLoc, Location toLoc, String fromName, String toName, final CarpoolInterface carpoolInterface){


        if(CommonMethods.isLocValid(toLoc) && CommonMethods.isLocValid(fromLoc)) {
            String sourceParams = URLEncoder.encode(fromName);
            String destinationParams = URLEncoder.encode(toName);

            String route = Constants.getBaseUrl() + String.format(ctx.getString(R.string.search_carpools),
                    toLoc.getLatitude(), toLoc.getLongitude(), fromLoc.getLatitude(), fromLoc.getLongitude(), sourceParams, destinationParams);
            Restify<MasterCarpool> restify = new Restify<>(ctx, route, MasterCarpool.class);
            restify.get(false, new RestifyGenericCallback() {
                @Override
                public void callback(JSONObject error, Object model) {
                    try {

                        if (error == null) {
                            MasterCarpool masterCarpool = (MasterCarpool) model;
                            carpoolInterface.onSuccess(masterCarpool.getCarPools());
                        } else
                            carpoolInterface.onError(error);

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }else
            carpoolInterface.onLocationError();
    }

    public static void fetchUsersTravellingRightNow(){

    }

    public interface CarpoolInterface{
        void onSuccess(ArrayList<CarPool> carpools);
        void onError(JSONObject jsonObject);
        void onLocationError();
    }

}
