/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.webflux;

import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.constraints.ConstraintReaderImpl;
import capital.scalable.restdocs.i18n.SnippetTranslationManager;
import capital.scalable.restdocs.jackson.TypeMapping;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.javadoc.JavadocReaderImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.restdocs.constraints.ConstraintDescriptionResolver;
import org.springframework.restdocs.constraints.ResourceBundleConstraintDescriptionResolver;
import org.springframework.restdocs.snippet.Snippet;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebTestClientInitializer
implements HandlerAdapter,
Ordered {
    private HandlerMethod handlerMethod;

    public boolean supports(Object handler) {
        if (handler instanceof HandlerMethod) {
            this.handlerMethod = (HandlerMethod)handler;
        }
        return false;
    }

    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        return Mono.empty();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public static Snippet prepareSnippets(ApplicationContext context) {
        return WebTestClientInitializer.prepareSnippets(context, new TypeMapping());
    }

    public static Snippet prepareSnippets(ApplicationContext context, TypeMapping typeMapping) {
        if (context.getBeansOfType(WebTestClientInitializer.class).isEmpty()) {
            ((ConfigurableApplicationContext)context).getBeanFactory().registerSingleton(WebTestClientInitializer.class.getName(), (Object)new WebTestClientInitializer());
            ((DispatcherHandler)context.getBean(DispatcherHandler.class)).setApplicationContext(context);
        }
        return operation -> {
            HandlerMethod handlerMethod = ((WebTestClientInitializer)context.getBean(WebTestClientInitializer.class)).handlerMethod;
            operation.getAttributes().put(HandlerMethod.class.getName(), handlerMethod);
            ObjectMapper objectMapper = (ObjectMapper)context.getBean(ObjectMapper.class);
            operation.getAttributes().put(ObjectMapper.class.getName(), objectMapper);
            operation.getAttributes().put(JavadocReader.class.getName(), JavadocReaderImpl.createWithSystemProperty());
            operation.getAttributes().put(ConstraintReader.class.getName(), ConstraintReaderImpl.create(objectMapper, SnippetTranslationManager.getDefaultResolver(), (ConstraintDescriptionResolver)new ResourceBundleConstraintDescriptionResolver()));
            operation.getAttributes().put(TypeMapping.class.getName(), typeMapping);
            String requestPattern = (String)operation.getAttributes().get("org.springframework.restdocs.urlTemplate");
            if (StringUtils.isNotEmpty((CharSequence)requestPattern)) {
                operation.getAttributes().put("REQUEST_PATTERN", requestPattern);
            } else if (operation.getRequest() != null) {
                String path = operation.getRequest().getUri().getPath();
                String query = operation.getRequest().getUri().getQuery();
                operation.getAttributes().put("REQUEST_PATTERN", path + (StringUtils.isNotEmpty((CharSequence)query) ? "?" + query : ""));
            }
        };
    }
}

