/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.jackson.TypeMapping;
import com.fasterxml.jackson.databind.JavaType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeRegistry {
    private static final Logger log = LoggerFactory.getLogger(TypeRegistry.class);
    private final Set<JavaType> visited;
    private final TypeMapping mapping;

    public TypeRegistry(TypeMapping mapping, JavaType baseType) {
        this.mapping = mapping;
        this.visited = new HashSet<JavaType>();
        this.visited.add(baseType);
    }

    public TypeRegistry(TypeMapping mapping, Collection<JavaType> visited) {
        this.mapping = mapping;
        this.visited = new HashSet<JavaType>();
        this.visited.addAll(visited);
    }

    public TypeRegistry withVisitedTypes(List<JavaType> javaTypes) {
        HashSet<JavaType> result = new HashSet<JavaType>(this.visited);
        result.addAll(javaTypes);
        return new TypeRegistry(this.mapping, result);
    }

    public boolean wasVisited(JavaType type) {
        log.trace(" - WAS VISITED? {}", (Object)type.getRawClass().getSimpleName());
        for (JavaType t : this.visited) {
            if (t.getRawClass().equals(type.getRawClass())) {
                log.trace("   - YES {}", (Object)t.getRawClass().getSimpleName());
                return true;
            }
            log.trace("   - NO {}", (Object)t.getRawClass().getSimpleName());
        }
        return false;
    }

    public TypeMapping getTypeMapping() {
        return this.mapping;
    }
}

