/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.i18n;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.i18n.SnippetTranslationManager;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;

public abstract class TranslationHandlers {
    public static ResultHandler defaultTranslation() {
        return new TranslationPreparingResultHandler(SnippetTranslationManager.getDefaultResolver());
    }

    public static ResultHandler translation(SnippetTranslationResolver translationResolver) {
        return new TranslationPreparingResultHandler(translationResolver);
    }

    private static class TranslationPreparingResultHandler
    implements ResultHandler {
        private final SnippetTranslationResolver translationResolver;

        public TranslationPreparingResultHandler(SnippetTranslationResolver translationResolver) {
            this.translationResolver = translationResolver;
        }

        public void handle(MvcResult mvcResult) throws Exception {
            OperationAttributeHelper.setTranslationResolver(mvcResult.getRequest(), this.translationResolver);
        }
    }
}

