/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.constraints.ConstraintReaderImpl;
import capital.scalable.restdocs.jackson.TypeMapping;
import capital.scalable.restdocs.javadoc.JavadocReaderImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.web.method.HandlerMethod;

public abstract class JacksonResultHandlers {
    public static ResultHandler prepareJackson(ObjectMapper objectMapper) {
        return new JacksonPreparingResultHandler(objectMapper, new TypeMapping());
    }

    public static ResultHandler prepareJackson(ObjectMapper objectMapper, TypeMapping typeMapping) {
        return new JacksonPreparingResultHandler(objectMapper, typeMapping);
    }

    private static class JacksonPreparingResultHandler
    implements ResultHandler {
        private final ObjectMapper objectMapper;
        private final TypeMapping typeMapping;

        public JacksonPreparingResultHandler(ObjectMapper objectMapper, TypeMapping typeMapping) {
            this.objectMapper = objectMapper;
            this.typeMapping = typeMapping;
        }

        public void handle(MvcResult result) throws Exception {
            if (result.getHandler() instanceof HandlerMethod) {
                OperationAttributeHelper.setHandlerMethod(result.getRequest(), (HandlerMethod)result.getHandler());
            }
            OperationAttributeHelper.setObjectMapper(result.getRequest(), this.objectMapper);
            OperationAttributeHelper.initRequestPattern(result.getRequest());
            OperationAttributeHelper.setJavadocReader(result.getRequest(), JavadocReaderImpl.createWithSystemProperty());
            OperationAttributeHelper.setConstraintReader(result.getRequest(), ConstraintReaderImpl.create(this.objectMapper));
            OperationAttributeHelper.setTypeMapping(result.getRequest(), this.typeMapping);
        }
    }
}

