/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.DeprecatedAttribute;
import capital.scalable.restdocs.jackson.InternalFieldInfo;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.util.FieldUtil;
import capital.scalable.restdocs.util.FormatUtil;
import capital.scalable.restdocs.util.TypeUtil;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.PayloadDocumentation;
import org.springframework.restdocs.snippet.Attributes;

class FieldDocumentationVisitorContext {
    private static final Logger log = LoggerFactory.getLogger(FieldDocumentationVisitorContext.class);
    private final List<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
    private final JavadocReader javadocReader;
    private final ConstraintReader constraintReader;
    private final DeserializationConfig deserializationConfig;

    public FieldDocumentationVisitorContext(JavadocReader javadocReader, ConstraintReader constraintReader, DeserializationConfig deserializationConfig) {
        this.javadocReader = javadocReader;
        this.constraintReader = constraintReader;
        this.deserializationConfig = deserializationConfig;
    }

    public List<FieldDescriptor> getFields() {
        return this.fields;
    }

    public void addField(InternalFieldInfo info, String jsonType) {
        String jsonFieldPath = info.getJsonFieldPath();
        String javaFieldTypeName = info.getJavaFieldType().getRawClass().getSimpleName();
        Class<?> javaBaseClass = info.getJavaBaseClass();
        String javaFieldName = info.getJavaFieldName();
        String comment = this.resolveComment(javaBaseClass, javaFieldName);
        comment = FormatUtil.join("<br>", comment, this.resolveSeeTag(javaBaseClass, javaFieldName));
        List<String> constraints = this.constraintAttribute(javaBaseClass, javaFieldName);
        List<String> optionals = this.optionalAttribute(javaBaseClass, javaFieldName, info.isRequired());
        DeprecatedAttribute deprecated = this.deprecatedAttribute(javaBaseClass, javaFieldName);
        FieldDescriptor descriptor = this.getOrCreate(jsonFieldPath, jsonType, javaFieldTypeName);
        if (javaBaseClass.equals(descriptor.getAttributes().get("type"))) {
            return;
        }
        String updatedComment = this.joinWithTypeSpecifier(javaBaseClass, (String)descriptor.getDescription(), comment);
        List<String> updatedConstraints = this.joinWithTypeSpecifier(javaBaseClass, (List)descriptor.getAttributes().get("constraints"), constraints);
        List<String> updatedOptionals = this.joinWithTypeSpecifier(javaBaseClass, (List)descriptor.getAttributes().get("optionals"), optionals);
        DeprecatedAttribute updatedDeprecated = this.joinWithTypeSpecifier(javaBaseClass, (DeprecatedAttribute)descriptor.getAttributes().get("deprecated"), deprecated);
        ((FieldDescriptor)descriptor.description((Object)updatedComment)).attributes(new Attributes.Attribute[]{new Attributes.Attribute("type", javaBaseClass), new Attributes.Attribute("constraints", updatedConstraints), new Attributes.Attribute("optionals", updatedOptionals), new Attributes.Attribute("deprecated", (Object)updatedDeprecated)});
        if (!this.fields.contains(descriptor.getPath())) {
            this.fields.add(descriptor);
        }
        log.debug("({}) {} added", (Object)jsonFieldPath, (Object)javaFieldTypeName);
    }

    private String joinWithTypeSpecifier(Class<?> javaBaseClass, String oldComment, String newComment) {
        if (StringUtils.isBlank((CharSequence)newComment)) {
            return StringUtils.trimToEmpty((String)oldComment);
        }
        String typeSpecifier = this.typeSpecifier(javaBaseClass);
        if (StringUtils.isNotBlank((CharSequence)typeSpecifier)) {
            typeSpecifier = " " + typeSpecifier;
        }
        return FormatUtil.join("<br>", StringUtils.trimToEmpty((String)oldComment), newComment + typeSpecifier);
    }

    private DeprecatedAttribute joinWithTypeSpecifier(Class<?> javaBaseClass, DeprecatedAttribute oldAttr, DeprecatedAttribute newAttr) {
        if (!newAttr.isDeprecated()) {
            return oldAttr;
        }
        String typeSpecifier = this.typeSpecifier(javaBaseClass);
        if (StringUtils.isNotBlank((CharSequence)typeSpecifier)) {
            typeSpecifier = " " + typeSpecifier;
        }
        ArrayList<String> nl = new ArrayList<String>();
        if (oldAttr != null) {
            nl.addAll(oldAttr.getValues());
        }
        nl.addAll(newAttr.getValues());
        return new DeprecatedAttribute(true, nl);
    }

    private List<String> joinWithTypeSpecifier(Class<?> javaBaseClass, List<String> oldTexts, List<String> newTexts) {
        String typeSpecifier;
        ArrayList<String> result = new ArrayList<String>();
        if (oldTexts != null) {
            result.addAll(oldTexts);
        }
        if (StringUtils.isNotBlank((CharSequence)(typeSpecifier = this.typeSpecifier(javaBaseClass)))) {
            typeSpecifier = " " + typeSpecifier;
        }
        for (String newText : newTexts) {
            result.add(newText + typeSpecifier);
        }
        return result;
    }

    private String typeSpecifier(Class<?> javaBaseClass) {
        return StringUtils.trimToEmpty((String)this.constraintReader.getTypeSpecifier(javaBaseClass));
    }

    private FieldDescriptor getOrCreate(String jsonFieldPath, String jsonType, String javaFieldTypeName) {
        log.trace(" = WAS ADDED? {}", (Object)jsonFieldPath);
        for (FieldDescriptor descriptor : this.fields) {
            if (jsonFieldPath.equals(descriptor.getPath())) {
                log.trace("   = YES {}", (Object)descriptor.getPath());
                log.debug("({}) {} NOT added", (Object)jsonFieldPath, (Object)javaFieldTypeName);
                if (!descriptor.getType().equals(jsonType)) {
                    log.warn("Multiple fields with the same path {} but different types!", (Object)jsonFieldPath);
                }
                return descriptor;
            }
            log.trace("   = NO {}", (Object)descriptor.getPath());
        }
        return PayloadDocumentation.fieldWithPath((String)jsonFieldPath).type((Object)jsonType);
    }

    private List<String> constraintAttribute(Class<?> javaBaseClass, String javaFieldName) {
        return this.resolveConstraintDescriptions(javaBaseClass, javaFieldName);
    }

    private List<String> optionalAttribute(Class<?> javaBaseClass, String javaFieldName, boolean requiredField) {
        return this.resolveOptionalMessages(javaBaseClass, javaFieldName, requiredField);
    }

    private DeprecatedAttribute deprecatedAttribute(Class<?> javaBaseClass, String javaFieldName) {
        return this.resolveDeprecatedMessage(javaBaseClass, javaFieldName);
    }

    private List<String> resolveOptionalMessages(Class<?> javaBaseClass, String javaFieldName, boolean requiredField) {
        ArrayList<String> optionalMessages = new ArrayList<String>();
        if (requiredField) {
            optionalMessages.add("false");
            return optionalMessages;
        }
        if (TypeUtil.isPrimitive(javaBaseClass, javaFieldName)) {
            boolean failOnNullForPrimitives = this.deserializationConfig.hasDeserializationFeatures(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES.getMask());
            optionalMessages.add("" + !failOnNullForPrimitives);
            return optionalMessages;
        }
        optionalMessages.addAll(this.constraintReader.getOptionalMessages(javaBaseClass, javaFieldName));
        if (optionalMessages.isEmpty() && FieldUtil.isGetter(javaFieldName)) {
            optionalMessages.addAll(this.constraintReader.getOptionalMessages(javaBaseClass, FieldUtil.fromGetter(javaFieldName)));
        }
        if (!optionalMessages.contains("false") && !optionalMessages.contains("true")) {
            optionalMessages.add(0, "true");
        }
        return optionalMessages;
    }

    private List<String> resolveConstraintDescriptions(Class<?> javaBaseClass, String javaFieldName) {
        ArrayList<String> descriptions = new ArrayList<String>();
        descriptions.addAll(this.constraintReader.getConstraintMessages(javaBaseClass, javaFieldName));
        if (descriptions.isEmpty() && FieldUtil.isGetter(javaFieldName)) {
            descriptions.addAll(this.constraintReader.getConstraintMessages(javaBaseClass, FieldUtil.fromGetter(javaFieldName)));
        }
        return descriptions;
    }

    private DeprecatedAttribute resolveDeprecatedMessage(Class<?> javaBaseClass, String javaFieldName) {
        boolean isDeprecated = TypeUtil.resolveAnnotation(javaBaseClass, javaFieldName, Deprecated.class) != null;
        String comment = this.resolveTag(javaBaseClass, javaFieldName, "deprecated");
        if (isDeprecated || StringUtils.isNotBlank((CharSequence)comment)) {
            return new DeprecatedAttribute(true, Collections.singletonList(StringUtils.trimToEmpty((String)comment)));
        }
        return new DeprecatedAttribute(false, Collections.emptyList());
    }

    private String resolveSeeTag(Class<?> javaBaseClass, String javaFieldName) {
        String comment = this.resolveTag(javaBaseClass, javaFieldName, "see");
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            return FormatUtil.addDot(SnippetTranslationResolver.translate("tags-see", comment));
        }
        return "";
    }

    private String resolveComment(Class<?> javaBaseClass, String javaFieldOrMethodName) {
        String comment = this.javadocReader.resolveMethodComment(javaBaseClass, javaFieldOrMethodName);
        if (StringUtils.isBlank((CharSequence)comment)) {
            comment = this.javadocReader.resolveFieldComment(javaBaseClass, javaFieldOrMethodName);
        }
        if (StringUtils.isBlank((CharSequence)comment) && FieldUtil.isGetter(javaFieldOrMethodName)) {
            comment = this.javadocReader.resolveFieldComment(javaBaseClass, FieldUtil.fromGetter(javaFieldOrMethodName));
        }
        return comment;
    }

    private String resolveTag(Class<?> javaBaseClass, String javaFieldOrMethodName, String tagName) {
        String comment = this.javadocReader.resolveMethodTag(javaBaseClass, javaFieldOrMethodName, tagName);
        if (StringUtils.isBlank((CharSequence)comment)) {
            comment = this.javadocReader.resolveFieldTag(javaBaseClass, javaFieldOrMethodName, tagName);
        }
        if (StringUtils.isBlank((CharSequence)comment) && FieldUtil.isGetter(javaFieldOrMethodName)) {
            comment = this.javadocReader.resolveFieldTag(javaBaseClass, FieldUtil.fromGetter(javaFieldOrMethodName), tagName);
        }
        return comment;
    }
}

