/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.jackson.FieldDescriptors;
import capital.scalable.restdocs.jackson.FieldDocumentationVisitorWrapper;
import capital.scalable.restdocs.jackson.TypeRegistry;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.util.TypeUtil;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.restdocs.payload.FieldDescriptor;

public class FieldDocumentationGenerator {
    private static final Logger log = LoggerFactory.getLogger(FieldDocumentationGenerator.class);
    private static final String RESOURCES_TYPE = "org.springframework.hateoas.Resources";
    private final ObjectWriter writer;
    private final DeserializationConfig deserializationConfig;
    private final JavadocReader javadocReader;
    private final ConstraintReader constraintReader;

    public FieldDocumentationGenerator(ObjectWriter writer, DeserializationConfig deserializationConfig, JavadocReader javadocReader, ConstraintReader constraintReader) {
        this.writer = writer;
        this.deserializationConfig = deserializationConfig;
        this.javadocReader = javadocReader;
        this.constraintReader = constraintReader;
    }

    public FieldDescriptors generateDocumentation(Type baseType, TypeFactory typeFactory) throws JsonMappingException {
        JavaType javaBaseType = typeFactory.constructType(baseType);
        List<JavaType> types = TypeUtil.resolveAllTypes(javaBaseType, typeFactory);
        FieldDescriptors result = new FieldDescriptors();
        FieldDocumentationVisitorWrapper visitorWrapper = FieldDocumentationVisitorWrapper.create(this.javadocReader, this.constraintReader, this.deserializationConfig, new TypeRegistry(types), typeFactory);
        for (JavaType type : types) {
            log.debug("(TOP) {}", (Object)type.getRawClass().getSimpleName());
            if (RESOURCES_TYPE.equals(type.getRawClass().getCanonicalName())) {
                result.setNoContentMessageKey("body-as-embedded-resources");
                continue;
            }
            this.writer.acceptJsonFormatVisitor(type, (JsonFormatVisitorWrapper)visitorWrapper);
        }
        for (FieldDescriptor descriptor : visitorWrapper.getFields()) {
            result.putIfAbsent(descriptor.getPath(), descriptor);
        }
        return result;
    }
}

