/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.payload;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.FieldDescriptors;
import capital.scalable.restdocs.jackson.FieldDocumentationGenerator;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.payload.JacksonFieldProcessingException;
import capital.scalable.restdocs.section.SectionSupport;
import capital.scalable.restdocs.snippet.StandardTableSnippet;
import capital.scalable.restdocs.util.FieldDescriptorUtil;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.operation.Operation;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractJacksonFieldSnippet
extends StandardTableSnippet
implements SectionSupport {
    private static Class<?> SCALA_TRAVERSABLE;

    protected AbstractJacksonFieldSnippet(String snippetName, Map<String, Object> attributes) {
        super(snippetName, attributes);
    }

    @Override
    protected FieldDescriptors createFieldDescriptors(Operation operation, HandlerMethod handlerMethod) {
        ObjectMapper objectMapper = OperationAttributeHelper.getObjectMapper(operation);
        JavadocReader javadocReader = OperationAttributeHelper.getJavadocReader(operation);
        ConstraintReader constraintReader = OperationAttributeHelper.getConstraintReader(operation);
        Type type = this.getType(handlerMethod);
        if (type == null) {
            return new FieldDescriptors();
        }
        try {
            FieldDescriptors fieldDescriptors = this.resolveFieldDescriptors(type, objectMapper, javadocReader, constraintReader);
            if (this.shouldFailOnUndocumentedFields()) {
                FieldDescriptorUtil.assertAllDocumented(fieldDescriptors.values(), SnippetTranslationResolver.translate(this.getHeaderKey(), new Object[0]).toLowerCase());
            }
            return fieldDescriptors;
        }
        catch (JsonMappingException e) {
            throw new JacksonFieldProcessingException("Error while parsing fields", e);
        }
    }

    protected Type firstGenericType(MethodParameter param) {
        Type type = param.getGenericParameterType();
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    protected abstract Type getType(HandlerMethod var1);

    protected abstract boolean shouldFailOnUndocumentedFields();

    protected boolean isCollection(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || Stream.class.isAssignableFrom(type) || SCALA_TRAVERSABLE != null && SCALA_TRAVERSABLE.isAssignableFrom(type);
    }

    private FieldDescriptors resolveFieldDescriptors(Type type, ObjectMapper objectMapper, JavadocReader javadocReader, ConstraintReader constraintReader) throws JsonMappingException {
        FieldDocumentationGenerator generator = new FieldDocumentationGenerator(objectMapper.writer(), objectMapper.getDeserializationConfig(), javadocReader, constraintReader);
        return generator.generateDocumentation(type, objectMapper.getTypeFactory());
    }

    @Override
    public String getFileName() {
        return this.getSnippetName();
    }

    @Override
    public boolean hasContent(Operation operation) {
        return this.getType(OperationAttributeHelper.getHandlerMethod(operation)) != null;
    }

    static {
        try {
            SCALA_TRAVERSABLE = Class.forName("scala.collection.Traversable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

