/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs;

import capital.scalable.restdocs.section.SectionSupport;
import java.util.HashMap;
import java.util.Map;
import org.springframework.restdocs.operation.Operation;

public class SnippetRegistry {
    public static final String AUTHORIZATION = "auto-authorization";
    public static final String DESCRIPTION = "auto-description";
    public static final String METHOD_PATH = "auto-method-path";
    public static final String PATH_PARAMETERS = "auto-path-parameters";
    public static final String REQUEST_HEADERS = "auto-request-headers";
    public static final String REQUEST_PARAMETERS = "auto-request-parameters";
    public static final String REQUEST_FIELDS = "auto-request-fields";
    public static final String RESPONSE_FIELDS = "auto-response-fields";
    public static final String CURL_REQUEST = "curl-request";
    public static final String HTTP_REQUEST = "http-request";
    public static final String HTTP_RESPONSE = "http-response";
    public static final String HTTPIE_REQUEST = "httpie-request";
    private static final Map<String, SectionSupport> CLASSIC_SNIPPETS = new HashMap<String, SectionSupport>();

    public static SectionSupport getClassicSnippet(String snippetName) {
        return CLASSIC_SNIPPETS.get(snippetName);
    }

    private static SectionSupport section(String snippetName, String header, boolean hasContent) {
        return new ClassicSnippetSection(snippetName, header, hasContent);
    }

    private SnippetRegistry() {
    }

    static {
        CLASSIC_SNIPPETS.put(CURL_REQUEST, SnippetRegistry.section(CURL_REQUEST, "example-request", true));
        CLASSIC_SNIPPETS.put(HTTPIE_REQUEST, SnippetRegistry.section(HTTPIE_REQUEST, "example-request", true));
        CLASSIC_SNIPPETS.put(HTTP_REQUEST, SnippetRegistry.section(HTTP_REQUEST, "example-request", true));
        CLASSIC_SNIPPETS.put(HTTP_RESPONSE, SnippetRegistry.section(HTTP_RESPONSE, "example-response", true));
    }

    private static class ClassicSnippetSection
    implements SectionSupport {
        private String fileName;
        private String headerKey;
        private boolean hasContent;

        public ClassicSnippetSection(String fileName, String headerKey, boolean hasContent) {
            this.fileName = fileName;
            this.headerKey = headerKey;
            this.hasContent = hasContent;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public String getHeaderKey() {
            return this.headerKey;
        }

        @Override
        public boolean hasContent(Operation operation) {
            return this.hasContent;
        }
    }
}

