/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.response;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.OperationRequestPartFactory;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessorAdapter;

public class MultipartContentOperationPreprocessor
extends OperationPreprocessorAdapter {
    private static final byte[] BINARY_REPLACEMENT = "<binary>".getBytes(StandardCharsets.UTF_8);
    private final OperationRequestPartFactory partFactory = new OperationRequestPartFactory();
    private final OperationRequestFactory requestFactory = new OperationRequestFactory();

    public OperationRequest preprocess(OperationRequest request) {
        if (this.isMultipart(request)) {
            List parts = request.getParts().stream().map(this::replaceBinary).collect(Collectors.toList());
            return this.requestFactory.create(request.getUri(), request.getMethod(), request.getContent(), request.getHeaders(), request.getParameters(), parts);
        }
        return request;
    }

    private boolean isMultipart(OperationRequest request) {
        List contentTypes = request.getHeaders().get((Object)"Content-Type");
        return contentTypes != null && contentTypes.contains("multipart/form-data");
    }

    private OperationRequestPart replaceBinary(OperationRequestPart part) {
        return this.partFactory.create(part.getName(), part.getSubmittedFileName(), BINARY_REPLACEMENT, part.getHeaders());
    }
}

