/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.response;

import capital.scalable.restdocs.response.JsonModifyingException;
import capital.scalable.restdocs.response.JsonNodeConsumer;
import capital.scalable.restdocs.response.JsonNodeFilter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.preprocess.ContentModifier;

public abstract class JsonContentModifier
implements ContentModifier {
    private static final List<MediaType> supportedMediaTypes = Arrays.asList(MediaType.APPLICATION_JSON, MediaType.valueOf((String)"application/*+json"));
    private final ObjectMapper objectMapper;

    public JsonContentModifier(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public byte[] modifyContent(byte[] originalContent, MediaType contentType) {
        if (originalContent.length > 0 && supportedMediaTypes.stream().anyMatch(type -> type.isCompatibleWith(contentType))) {
            return this.modifyContent(originalContent);
        }
        return originalContent;
    }

    protected byte[] modifyContent(byte[] originalContent) {
        try {
            JsonNode root = this.objectMapper.readTree(originalContent);
            this.modifyJson(root);
            return this.objectMapper.writeValueAsBytes((Object)root);
        }
        catch (IOException e) {
            throw new JsonModifyingException("Failed to modify JSON response", e);
        }
    }

    protected abstract void modifyJson(JsonNode var1);

    protected void walk(JsonNode node, JsonNodeFilter filter, JsonNodeConsumer consumer) {
        if (filter.apply(node)) {
            consumer.accept(node);
        }
        for (JsonNode child : node) {
            this.walk(child, filter, consumer);
        }
    }
}

