/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.payload;

import capital.scalable.restdocs.payload.AbstractJacksonFieldSnippet;
import capital.scalable.restdocs.util.TypeUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;
import org.springframework.restdocs.operation.Operation;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.method.HandlerMethod;

public class JacksonRequestFieldSnippet
extends AbstractJacksonFieldSnippet {
    private final Type requestBodyType;
    private final boolean failOnUndocumentedFields;

    public JacksonRequestFieldSnippet() {
        this(null, false);
    }

    public JacksonRequestFieldSnippet(Type requestBodyType, boolean failOnUndocumentedFields) {
        super("auto-request-fields", null);
        this.requestBodyType = requestBodyType;
        this.failOnUndocumentedFields = failOnUndocumentedFields;
    }

    public JacksonRequestFieldSnippet requestBodyAsType(Type requestBodyType) {
        return new JacksonRequestFieldSnippet(requestBodyType, this.failOnUndocumentedFields);
    }

    public JacksonRequestFieldSnippet failOnUndocumentedFields(boolean failOnUndocumentedFields) {
        return new JacksonRequestFieldSnippet(this.requestBodyType, failOnUndocumentedFields);
    }

    @Override
    protected Type[] getType(HandlerMethod method) {
        if (this.requestBodyType != null) {
            return new Type[]{this.requestBodyType};
        }
        for (MethodParameter param : method.getMethodParameters()) {
            if (!this.isRequestBody(param)) continue;
            return new Type[]{this.getType(param)};
        }
        return null;
    }

    private boolean isRequestBody(MethodParameter param) {
        return param.getParameterAnnotation(RequestBody.class) != null;
    }

    private Type getType(MethodParameter param) {
        if (this.isCollection(param.getParameterType())) {
            return () -> TypeUtil.firstGenericType(param);
        }
        return param.getParameterType();
    }

    @Override
    public String getHeaderKey(Operation operation) {
        return "request-fields";
    }

    @Override
    protected boolean shouldFailOnUndocumentedFields() {
        return this.failOnUndocumentedFields;
    }

    @Override
    protected String[] getTranslationKeys() {
        return new String[]{"th-path", "th-type", "th-optional", "th-description", "no-request-body"};
    }

    @Override
    protected JsonProperty.Access getSkipAcessor() {
        return JsonProperty.Access.READ_ONLY;
    }

    @Override
    public boolean isMergeable() {
        return true;
    }
}

