/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jackson;

import capital.scalable.restdocs.constraints.ConstraintReader;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import capital.scalable.restdocs.jackson.FieldDescriptors;
import capital.scalable.restdocs.jackson.FieldDocumentationVisitorWrapper;
import capital.scalable.restdocs.jackson.TypeMapping;
import capital.scalable.restdocs.jackson.TypeRegistry;
import capital.scalable.restdocs.javadoc.JavadocReader;
import capital.scalable.restdocs.util.TypeUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.restdocs.payload.FieldDescriptor;

public class FieldDocumentationGenerator {
    private static final Logger log = LoggerFactory.getLogger(FieldDocumentationGenerator.class);
    private static final Set<String> RESOURCES_TYPES = new HashSet<String>(Arrays.asList("org.springframework.hateoas.Resources", "org.springframework.hateoas.CollectionModel"));
    private final ObjectWriter writer;
    private final DeserializationConfig deserializationConfig;
    private final JavadocReader javadocReader;
    private final ConstraintReader constraintReader;
    private final TypeMapping typeMapping;
    private final SnippetTranslationResolver translationResolver;
    private final JsonProperty.Access skipAccessor;

    public FieldDocumentationGenerator(ObjectWriter writer, DeserializationConfig deserializationConfig, JavadocReader javadocReader, ConstraintReader constraintReader, TypeMapping typeMapping, SnippetTranslationResolver translationResolver, JsonProperty.Access skipAccessor) {
        this.writer = writer;
        this.deserializationConfig = deserializationConfig;
        this.javadocReader = javadocReader;
        this.constraintReader = constraintReader;
        this.typeMapping = typeMapping;
        this.translationResolver = translationResolver;
        this.skipAccessor = skipAccessor;
    }

    public FieldDescriptors generateDocumentation(Type baseType, TypeFactory typeFactory) throws JsonMappingException {
        return this.generateDocumentation(new Type[]{baseType}, typeFactory);
    }

    public FieldDescriptors generateDocumentation(Type[] baseTypes, TypeFactory typeFactory) throws JsonMappingException {
        List<JavaType> types = Arrays.stream(baseTypes).map(arg_0 -> ((TypeFactory)typeFactory).constructType(arg_0)).map(type -> TypeUtil.resolveAllTypes(type, typeFactory, this.typeMapping)).flatMap(Collection::stream).collect(Collectors.toList());
        FieldDescriptors result = new FieldDescriptors();
        FieldDocumentationVisitorWrapper visitorWrapper = FieldDocumentationVisitorWrapper.create(this.javadocReader, this.constraintReader, this.deserializationConfig, new TypeRegistry(this.typeMapping, types), typeFactory, this.translationResolver, this.skipAccessor);
        for (JavaType type2 : types) {
            log.debug("(TOP) {}", (Object)type2.getRawClass().getSimpleName());
            if (RESOURCES_TYPES.contains(type2.getRawClass().getCanonicalName())) {
                result.setNoContentMessageKey("body-as-embedded-resources");
                continue;
            }
            this.writer.acceptJsonFormatVisitor(type2, (JsonFormatVisitorWrapper)visitorWrapper);
        }
        for (FieldDescriptor descriptor : visitorWrapper.getFields()) {
            result.putIfAbsent(descriptor.getPath(), descriptor);
        }
        return result;
    }
}

