/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.constraints;

import capital.scalable.restdocs.constraints.GroupDescriptionResolver;
import capital.scalable.restdocs.i18n.SnippetTranslationResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.restdocs.constraints.Constraint;
import org.springframework.restdocs.constraints.ConstraintDescriptionResolver;

public class ConstraintAndGroupDescriptionResolver
implements ConstraintDescriptionResolver,
GroupDescriptionResolver {
    static final String GROUPS = "groups";
    static final String VALUE = "value";
    private final ConstraintDescriptionResolver delegate;
    private final SnippetTranslationResolver translationResolver;

    public ConstraintAndGroupDescriptionResolver(ConstraintDescriptionResolver delegate, SnippetTranslationResolver translationResolver) {
        this.delegate = delegate;
        this.translationResolver = translationResolver;
    }

    public String resolveDescription(Constraint constraint) {
        List<Class<?>> groups;
        String constraintDescription = StringUtils.trimToEmpty((String)this.resolvePlainDescription(constraint));
        if (StringUtils.isBlank((CharSequence)constraintDescription)) {
            constraintDescription = constraint.getName();
        }
        if ((groups = this.getGroups(constraint)).isEmpty()) {
            return constraintDescription;
        }
        StringBuilder result = new StringBuilder();
        for (Class<?> group : groups) {
            result.append(", ");
            result.append(StringUtils.trimToEmpty((String)this.resolveGroupDescription((Class)group, constraintDescription)));
        }
        result.replace(0, 2, "");
        return result.toString();
    }

    @Override
    public List<Class<?>> getGroups(Constraint constraint) {
        Object rawGroups = constraint.getConfiguration().get(GROUPS);
        if (!(rawGroups instanceof Class[])) {
            return Collections.emptyList();
        }
        Class[] groups = (Class[])rawGroups;
        ArrayList result = new ArrayList();
        Collections.addAll(result, groups);
        return result;
    }

    public String resolveGroupDescription(Class group, String constraintDescription) {
        Constraint groupConstraint = new Constraint(group.getCanonicalName(), Collections.singletonMap(VALUE, constraintDescription));
        String result = this.resolvePlainDescription(groupConstraint);
        return StringUtils.isBlank((CharSequence)result) ? this.fallbackGroupDescription(group, constraintDescription) : result;
    }

    private String fallbackGroupDescription(Class group, String constraintDescription) {
        return this.translationResolver.translate("constraints-groups", constraintDescription, group.getSimpleName());
    }

    private String resolvePlainDescription(Constraint constraint) {
        return this.delegate.resolveDescription(constraint);
    }
}

