/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs;

import capital.scalable.restdocs.section.SectionSupport;
import java.util.HashMap;
import java.util.Map;
import org.springframework.restdocs.operation.Operation;

public class SnippetRegistry {
    public static final String AUTO_AUTHORIZATION = "auto-authorization";
    public static final String AUTO_DESCRIPTION = "auto-description";
    public static final String AUTO_METHOD_PATH = "auto-method-path";
    public static final String AUTO_PATH_PARAMETERS = "auto-path-parameters";
    public static final String AUTO_REQUEST_HEADERS = "auto-request-headers";
    public static final String AUTO_REQUEST_PARAMETERS = "auto-request-parameters";
    public static final String AUTO_MODELATTRIBUTE = "auto-modelattribute";
    public static final String AUTO_REQUEST_FIELDS = "auto-request-fields";
    public static final String AUTO_RESPONSE_FIELDS = "auto-response-fields";
    public static final String AUTO_LINKS = "auto-links";
    public static final String AUTO_EMBEDDED = "auto-embedded";
    public static final String CURL_REQUEST = "curl-request";
    public static final String HTTP_REQUEST = "http-request";
    public static final String HTTP_RESPONSE = "http-response";
    public static final String HTTPIE_REQUEST = "httpie-request";
    public static final String PATH_PARAMETERS = "path-parameters";
    public static final String REQUEST_PARAMETERS = "request-parameters";
    public static final String REQUEST_FIELDS = "request-fields";
    public static final String RESPONSE_FIELDS = "response-fields";
    public static final String REQUEST_BODY_SNIPPET = "request-body";
    public static final String RESPONSE_BODY = "response-body";
    public static final String REQUEST_HEADERS = "request-headers";
    public static final String RESPONSE_HEADERS = "response-headers";
    public static final String REQUEST_PARTS = "request-parts";
    public static final String REQUEST_PART_FIELDS = "request-part-fields";
    public static final String LINKS = "links";
    private static final Map<String, SectionSupport> CLASSIC_SNIPPETS = new HashMap<String, SectionSupport>();

    public static SectionSupport getClassicSnippet(String snippetName) {
        return CLASSIC_SNIPPETS.get(snippetName);
    }

    private static SectionSupport section(String snippetName, String header, boolean hasContent) {
        return new ClassicSnippetSection(snippetName, header, hasContent);
    }

    private SnippetRegistry() {
    }

    static {
        CLASSIC_SNIPPETS.put(CURL_REQUEST, SnippetRegistry.section(CURL_REQUEST, "example-request", true));
        CLASSIC_SNIPPETS.put(HTTPIE_REQUEST, SnippetRegistry.section(HTTPIE_REQUEST, "example-request", true));
        CLASSIC_SNIPPETS.put(HTTP_REQUEST, SnippetRegistry.section(HTTP_REQUEST, "example-request", true));
        CLASSIC_SNIPPETS.put(HTTP_RESPONSE, SnippetRegistry.section(HTTP_RESPONSE, "example-response", true));
        CLASSIC_SNIPPETS.put(REQUEST_PARAMETERS, SnippetRegistry.section(REQUEST_PARAMETERS, REQUEST_PARAMETERS, true));
        CLASSIC_SNIPPETS.put(PATH_PARAMETERS, SnippetRegistry.section(PATH_PARAMETERS, PATH_PARAMETERS, true));
        CLASSIC_SNIPPETS.put(LINKS, SnippetRegistry.section(LINKS, "hypermedia-links", true));
        CLASSIC_SNIPPETS.put(REQUEST_FIELDS, SnippetRegistry.section(REQUEST_FIELDS, REQUEST_FIELDS, true));
        CLASSIC_SNIPPETS.put(RESPONSE_FIELDS, SnippetRegistry.section(RESPONSE_FIELDS, RESPONSE_FIELDS, true));
        CLASSIC_SNIPPETS.put(REQUEST_BODY_SNIPPET, SnippetRegistry.section(REQUEST_BODY_SNIPPET, REQUEST_BODY_SNIPPET, true));
        CLASSIC_SNIPPETS.put(RESPONSE_BODY, SnippetRegistry.section(RESPONSE_BODY, RESPONSE_BODY, true));
        CLASSIC_SNIPPETS.put(REQUEST_HEADERS, SnippetRegistry.section(REQUEST_HEADERS, REQUEST_HEADERS, true));
        CLASSIC_SNIPPETS.put(RESPONSE_HEADERS, SnippetRegistry.section(RESPONSE_HEADERS, RESPONSE_HEADERS, true));
        CLASSIC_SNIPPETS.put(REQUEST_PARTS, SnippetRegistry.section(REQUEST_PARTS, REQUEST_PARTS, true));
        CLASSIC_SNIPPETS.put(REQUEST_PART_FIELDS, SnippetRegistry.section(REQUEST_PART_FIELDS, REQUEST_PART_FIELDS, true));
    }

    private static class ClassicSnippetSection
    implements SectionSupport {
        private String fileName;
        private String headerKey;
        private boolean hasContent;

        public ClassicSnippetSection(String fileName, String headerKey, boolean hasContent) {
            this.fileName = fileName;
            this.headerKey = headerKey;
            this.hasContent = hasContent;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public String getHeaderKey(Operation operation) {
            return this.headerKey;
        }

        @Override
        public boolean hasContent(Operation operation) {
            return this.hasContent;
        }
    }
}

