/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.snippet;

import capital.scalable.restdocs.OperationAttributeHelper;
import capital.scalable.restdocs.javadoc.JavadocUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.web.method.HandlerMethod;

public abstract class StandardTableSnippet
extends TemplatedSnippet {
    protected StandardTableSnippet(String snippetName, Map<String, Object> attributes) {
        super(snippetName, attributes);
    }

    protected Map<String, Object> createModel(Operation operation) {
        HandlerMethod handlerMethod = OperationAttributeHelper.getHandlerMethod(operation);
        List<FieldDescriptor> fieldDescriptors = Collections.emptyList();
        if (handlerMethod != null) {
            fieldDescriptors = this.createFieldDescriptors(operation, handlerMethod);
        }
        String lineBreak = OperationAttributeHelper.determineLineBreak(operation);
        return this.createModel(handlerMethod, fieldDescriptors, lineBreak);
    }

    protected abstract Collection<FieldDescriptor> createFieldDescriptors(Operation var1, HandlerMethod var2);

    protected void enrichModel(Map<String, Object> model, HandlerMethod handlerMethod) {
    }

    private Map<String, Object> createModel(HandlerMethod handlerMethod, Collection<FieldDescriptor> fieldDescriptors, String lineBreak) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.enrichModel(model, handlerMethod);
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        model.put("content", fields);
        for (FieldDescriptor descriptor : fieldDescriptors) {
            fields.add(this.createModelForDescriptor(descriptor, lineBreak));
        }
        model.put("hasContent", !fieldDescriptors.isEmpty());
        model.put("noContent", fieldDescriptors.isEmpty());
        return model;
    }

    protected Map<String, Object> createModelForDescriptor(FieldDescriptor descriptor, String lineBreak) {
        String path = descriptor.getPath();
        String type = this.toString(descriptor.getType());
        String description = JavadocUtil.convertFromJavadoc(this.toString(descriptor.getDescription()), lineBreak);
        List optionalMessages = (List)descriptor.getAttributes().get("optionals");
        String optional = "" + StringUtils.join((Iterable)optionalMessages, (String)lineBreak);
        List constraints = (List)descriptor.getAttributes().get("constraints");
        description = this.joinAndFormat(lineBreak, description, constraints);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("path", path);
        model.put("type", type);
        model.put("optional", optional);
        model.put("description", description);
        return model;
    }

    private String toString(Object value) {
        if (value != null) {
            return StringUtils.trimToEmpty((String)value.toString());
        }
        return "";
    }

    private String joinAndFormat(String lineBreak, String description, List<String> constraints) {
        StringBuilder str = new StringBuilder(description);
        if (!description.isEmpty() && !description.endsWith(".")) {
            str.append('.');
        }
        for (String constraint : constraints) {
            if (constraint.trim().isEmpty()) continue;
            if (str.length() > 0) {
                str.append(lineBreak);
            }
            str.append(constraint.trim());
            if (constraint.endsWith(".")) continue;
            str.append('.');
        }
        return str.toString();
    }
}

